/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig$;

public class EmbeddedKafkaConfig {
    public static final int DEFAULT_NUMBER_OF_BROKERS = 1;
    public static final int USE_RANDOM_ZOOKEEPER_PORT = 0;
    private final int numberOfBrokers;
    private final Properties brokerProperties;

    public static EmbeddedKafkaConfigBuilder create() {
        return new EmbeddedKafkaConfigBuilder();
    }

    public static EmbeddedKafkaConfig useDefaults() {
        return EmbeddedKafkaConfig.create().build();
    }

    public int getNumberOfBrokers() {
        return this.numberOfBrokers;
    }

    public Properties getBrokerProperties() {
        return this.brokerProperties;
    }

    public String toString() {
        return "EmbeddedKafkaConfig(numberOfBrokers=" + this.getNumberOfBrokers() + ", brokerProperties=" + this.getBrokerProperties() + ")";
    }

    public EmbeddedKafkaConfig(int numberOfBrokers, Properties brokerProperties) {
        this.numberOfBrokers = numberOfBrokers;
        this.brokerProperties = brokerProperties;
    }

    public static class EmbeddedKafkaConfigBuilder {
        private int numberOfBrokers = 1;
        private Properties properties = new Properties();

        public EmbeddedKafkaConfigBuilder withNumberOfBrokers(int numberOfBrokers) {
            this.numberOfBrokers = numberOfBrokers;
            return this;
        }

        public <T> EmbeddedKafkaConfigBuilder with(String propertyName, T value) {
            this.properties.put(propertyName, value);
            return this;
        }

        public EmbeddedKafkaConfigBuilder withAll(Properties overrides) {
            this.properties.putAll((Map<?, ?>)overrides);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.properties.get(propertyName) != null) {
                return;
            }
            this.properties.put(propertyName, value);
        }

        public EmbeddedKafkaConfig build() {
            this.ifNonExisting(KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp(), "8000");
            this.ifNonExisting(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
            this.ifNonExisting(KafkaConfig$.MODULE$.HostNameProp(), "localhost");
            this.ifNonExisting(KafkaConfig$.MODULE$.PortProp(), "0");
            this.ifNonExisting(KafkaConfig$.MODULE$.NumPartitionsProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1000000");
            this.ifNonExisting(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), 0);
            this.ifNonExisting(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.SslClientAuthProp(), "none");
            this.ifNonExisting(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), 5);
            this.ifNonExisting(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), 1);
            this.ifNonExisting(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
            return new EmbeddedKafkaConfig(this.numberOfBrokers, this.properties);
        }
    }
}

