/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.StringDeserializer;

public class ReadKeyValues<K, V> {
    public static final int WITHOUT_LIMIT = -1;
    public static final int DEFAULT_MAX_TOTAL_POLL_TIME_MILLIS = 2000;
    private final String topic;
    private final int limit;
    private final int maxTotalPollTimeMillis;
    private final boolean includeMetadata;
    private final Map<Integer, Long> seekTo;
    private final Properties consumerProps;
    private final Predicate<K> filterOnKeys;
    private final Predicate<V> filterOnValues;
    private final Predicate<Headers> filterOnHeaders;
    private final Class<K> clazzOfK;
    private final Class<V> clazzOfV;

    public static ReadKeyValuesBuilder<String, String> from(String topic) {
        return ReadKeyValues.from(topic, String.class, String.class);
    }

    public static <V> ReadKeyValuesBuilder<String, V> from(String topic, Class<V> clazzOfV) {
        return ReadKeyValues.from(topic, String.class, clazzOfV);
    }

    public static <K, V> ReadKeyValuesBuilder<K, V> from(String topic, Class<K> clazzOfK, Class<V> clazzOfV) {
        return new ReadKeyValuesBuilder<K, V>(topic, clazzOfK, clazzOfV);
    }

    public String getTopic() {
        return this.topic;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getMaxTotalPollTimeMillis() {
        return this.maxTotalPollTimeMillis;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public Map<Integer, Long> getSeekTo() {
        return this.seekTo;
    }

    public Properties getConsumerProps() {
        return this.consumerProps;
    }

    public Predicate<K> getFilterOnKeys() {
        return this.filterOnKeys;
    }

    public Predicate<V> getFilterOnValues() {
        return this.filterOnValues;
    }

    public Predicate<Headers> getFilterOnHeaders() {
        return this.filterOnHeaders;
    }

    public Class<K> getClazzOfK() {
        return this.clazzOfK;
    }

    public Class<V> getClazzOfV() {
        return this.clazzOfV;
    }

    public String toString() {
        return "ReadKeyValues(topic=" + this.getTopic() + ", limit=" + this.getLimit() + ", maxTotalPollTimeMillis=" + this.getMaxTotalPollTimeMillis() + ", includeMetadata=" + this.isIncludeMetadata() + ", seekTo=" + this.getSeekTo() + ", consumerProps=" + this.getConsumerProps() + ", filterOnKeys=" + this.getFilterOnKeys() + ", filterOnValues=" + this.getFilterOnValues() + ", filterOnHeaders=" + this.getFilterOnHeaders() + ", clazzOfK=" + this.getClazzOfK() + ", clazzOfV=" + this.getClazzOfV() + ")";
    }

    public ReadKeyValues(String topic, int limit, int maxTotalPollTimeMillis, boolean includeMetadata, Map<Integer, Long> seekTo, Properties consumerProps, Predicate<K> filterOnKeys, Predicate<V> filterOnValues, Predicate<Headers> filterOnHeaders, Class<K> clazzOfK, Class<V> clazzOfV) {
        this.topic = topic;
        this.limit = limit;
        this.maxTotalPollTimeMillis = maxTotalPollTimeMillis;
        this.includeMetadata = includeMetadata;
        this.seekTo = seekTo;
        this.consumerProps = consumerProps;
        this.filterOnKeys = filterOnKeys;
        this.filterOnValues = filterOnValues;
        this.filterOnHeaders = filterOnHeaders;
        this.clazzOfK = clazzOfK;
        this.clazzOfV = clazzOfV;
    }

    public static class ReadKeyValuesBuilder<K, V> {
        private final String topic;
        private final Class<K> clazzOfK;
        private final Class<V> clazzOfV;
        private final Properties consumerProps = new Properties();
        private Predicate<K> filterOnKeys = key -> true;
        private Predicate<V> filterOnValues = value -> true;
        private Predicate<Headers> filterOnHeaders = value -> true;
        private int limit = -1;
        private int maxTotalPollTimeMillis = 2000;
        private boolean includeMetadata = false;
        private Map<Integer, Long> seekTo = new HashMap<Integer, Long>();

        ReadKeyValuesBuilder(String topic, Class<K> clazzOfK, Class<V> clazzOfV) {
            this.topic = topic;
            this.clazzOfK = clazzOfK;
            this.clazzOfV = clazzOfV;
        }

        public ReadKeyValuesBuilder<K, V> filterOnKeys(Predicate<K> filterOnKeys) {
            this.filterOnKeys = filterOnKeys;
            return this;
        }

        public ReadKeyValuesBuilder<K, V> filterOnValues(Predicate<V> filterOnValues) {
            this.filterOnValues = filterOnValues;
            return this;
        }

        public ReadKeyValuesBuilder<K, V> filterOnHeaders(Predicate<Headers> filterOnHeaders) {
            this.filterOnHeaders = filterOnHeaders;
            return this;
        }

        public ReadKeyValuesBuilder<K, V> unlimited() {
            this.limit = -1;
            return this;
        }

        public ReadKeyValuesBuilder<K, V> withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public ReadKeyValuesBuilder<K, V> withMaxTotalPollTime(int duration, TimeUnit unit) {
            this.maxTotalPollTimeMillis = (int)unit.toMillis(duration);
            return this;
        }

        public ReadKeyValuesBuilder<K, V> includeMetadata() {
            return this.withMetadata(true);
        }

        public ReadKeyValuesBuilder<K, V> withMetadata(boolean modifier) {
            this.includeMetadata = modifier;
            return this;
        }

        public ReadKeyValuesBuilder<K, V> seekTo(int partition, long offset) {
            this.seekTo.put(partition, offset);
            return this;
        }

        public ReadKeyValuesBuilder<K, V> seekTo(Map<Integer, Long> seekTo) {
            this.seekTo.putAll(seekTo);
            return this;
        }

        public <T> ReadKeyValuesBuilder<K, V> with(String propertyName, T value) {
            this.consumerProps.put(propertyName, value);
            return this;
        }

        public <T> ReadKeyValuesBuilder<K, V> withAll(Properties consumerProps) {
            this.consumerProps.putAll((Map<?, ?>)consumerProps);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.consumerProps.get(propertyName) != null) {
                return;
            }
            this.consumerProps.put(propertyName, value);
        }

        public ReadKeyValues<K, V> useDefaults() {
            this.consumerProps.clear();
            this.limit = -1;
            this.maxTotalPollTimeMillis = 2000;
            return this.build();
        }

        public ReadKeyValues<K, V> build() {
            this.ifNonExisting("group.id", UUID.randomUUID().toString());
            this.ifNonExisting("auto.offset.reset", "earliest");
            this.ifNonExisting("enable.auto.commit", false);
            this.ifNonExisting("key.deserializer", StringDeserializer.class);
            this.ifNonExisting("value.deserializer", StringDeserializer.class);
            this.ifNonExisting("max.poll.records", 100);
            this.ifNonExisting("isolation.level", "read_uncommitted");
            return new ReadKeyValues<K, V>(this.topic, this.limit, this.maxTotalPollTimeMillis, this.includeMetadata, this.seekTo, this.consumerProps, this.filterOnKeys, this.filterOnValues, this.filterOnHeaders, this.clazzOfK, this.clazzOfV);
        }
    }
}

