/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedKafkaConfig {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKafkaConfig.class);
    public static final int DEFAULT_NUMBER_OF_BROKERS = 1;
    public static final String DEFAULT_LISTENER = "PLAINTEXT://localhost:9092";
    private static final String LISTENER_TEMPLATE = "PLAINTEXT://localhost:%s";
    private final int numberOfBrokers;
    private final List<String> uniqueListeners;
    private final Properties brokerProperties;

    public String listenerFor(int brokerIndex) {
        if (this.brokerProperties.containsKey(KafkaConfig$.MODULE$.ListenersProp())) {
            return this.brokerProperties.getProperty(KafkaConfig$.MODULE$.ListenersProp());
        }
        return this.uniqueListeners.get(brokerIndex);
    }

    public static EmbeddedKafkaConfigBuilder brokers() {
        return new EmbeddedKafkaConfigBuilder();
    }

    @Deprecated
    public static EmbeddedKafkaConfigBuilder create() {
        return EmbeddedKafkaConfig.brokers();
    }

    public static EmbeddedKafkaConfig defaultBrokers() {
        return EmbeddedKafkaConfig.brokers().build();
    }

    @Deprecated
    public static EmbeddedKafkaConfig useDefaults() {
        return EmbeddedKafkaConfig.defaultBrokers();
    }

    public String toString() {
        return "EmbeddedKafkaConfig(numberOfBrokers=" + this.getNumberOfBrokers() + ", uniqueListeners=" + this.uniqueListeners + ", brokerProperties=" + this.getBrokerProperties() + ")";
    }

    public EmbeddedKafkaConfig(int numberOfBrokers, List<String> uniqueListeners, Properties brokerProperties) {
        this.numberOfBrokers = numberOfBrokers;
        this.uniqueListeners = uniqueListeners;
        this.brokerProperties = brokerProperties;
    }

    public int getNumberOfBrokers() {
        return this.numberOfBrokers;
    }

    public Properties getBrokerProperties() {
        return this.brokerProperties;
    }

    public static class EmbeddedKafkaConfigBuilder {
        private final Properties properties = new Properties();
        private int numberOfBrokers = 1;

        private EmbeddedKafkaConfigBuilder() {
        }

        public EmbeddedKafkaConfigBuilder withNumberOfBrokers(int numberOfBrokers) {
            this.numberOfBrokers = numberOfBrokers;
            return this;
        }

        public <T> EmbeddedKafkaConfigBuilder with(String propertyName, T value) {
            this.properties.put(propertyName, value);
            return this;
        }

        public EmbeddedKafkaConfigBuilder withAll(Properties overrides) {
            this.properties.putAll((Map<?, ?>)overrides);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.properties.get(propertyName) != null) {
                return;
            }
            this.properties.put(propertyName, value);
        }

        public EmbeddedKafkaConfig build() {
            ArrayList<String> listeners = new ArrayList<String>(this.numberOfBrokers);
            if (this.numberOfBrokers > 1) {
                listeners.addAll(this.getUniqueEphemeralPorts(this.numberOfBrokers).stream().map(port -> String.format(EmbeddedKafkaConfig.LISTENER_TEMPLATE, port)).collect(Collectors.toList()));
            } else {
                listeners.add(EmbeddedKafkaConfig.DEFAULT_LISTENER);
            }
            this.ifNonExisting(KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp(), "8000");
            this.ifNonExisting(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
            this.ifNonExisting(KafkaConfig$.MODULE$.NumPartitionsProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1000000");
            this.ifNonExisting(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), 0);
            this.ifNonExisting(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
            this.ifNonExisting(KafkaConfig$.MODULE$.SslClientAuthProp(), "none");
            this.ifNonExisting(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
            this.ifNonExisting(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), 5);
            this.ifNonExisting(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), 1);
            this.ifNonExisting(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
            return new EmbeddedKafkaConfig(this.numberOfBrokers, listeners, this.properties);
        }

        private List<Integer> getUniqueEphemeralPorts(int howMany) {
            ArrayList<Integer> ephemeralPorts = new ArrayList<Integer>(howMany);
            while (ephemeralPorts.size() < howMany) {
                int port = this.generateRandomEphemeralPort();
                if (ephemeralPorts.contains(port)) continue;
                ephemeralPorts.add(port);
            }
            return ephemeralPorts;
        }

        private int generateRandomEphemeralPort() {
            return Math.min((int)(Math.random() * 65535.0) + 1024, 65535);
        }
    }
}

