/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import net.mguenther.kafka.junit.EmbeddedLifecycle;
import net.mguenther.kafka.junit.EmbeddedZooKeeperConfig;
import org.apache.curator.test.TestingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedZooKeeper
implements EmbeddedLifecycle {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedZooKeeper.class);
    private final EmbeddedZooKeeperConfig config;
    private TestingServer internalServer;

    @Override
    public void start() {
        if (this.internalServer != null) {
            log.info("The embedded ZooKeeper instance is already running.");
            return;
        }
        try {
            log.info("Embedded ZooKeeper is starting.");
            this.internalServer = new TestingServer(this.config.getPort().intValue());
            log.info("Successfully started an embedded ZooKeeper instance at {} which is assigned to the temporary directory {}.", (Object)this.internalServer.getConnectString(), (Object)this.internalServer.getTempDirectory());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start an embedded ZooKeeper instance.", e);
        }
    }

    @Override
    public void stop() {
        if (this.internalServer == null) {
            log.info("The embedded ZooKeeper is not running or was already shut down.");
            return;
        }
        try {
            log.info("The embedded ZooKeeper instance at {} is stopping.", (Object)this.internalServer.getConnectString());
            this.internalServer.close();
            log.info("The embedded ZooKeeper instance at {} has been shut down.", (Object)this.internalServer.getConnectString());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to stop the embedded ZooKeeper instance.", e);
        }
    }

    public String getConnectString() {
        return this.internalServer.getConnectString();
    }

    public EmbeddedZooKeeper(EmbeddedZooKeeperConfig config) {
        this.config = config;
    }
}

