/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import net.mguenther.kafka.junit.KeyValue;
import org.apache.kafka.common.serialization.StringSerializer;

public class SendKeyValues<K, V> {
    private final String topic;
    private final Collection<KeyValue<K, V>> records;
    private final Properties producerProps;

    public static <K, V> SendKeyValuesBuilder<K, V> to(String topic, Collection<KeyValue<K, V>> records) {
        return new SendKeyValuesBuilder<K, V>(topic, records);
    }

    public String getTopic() {
        return this.topic;
    }

    public Collection<KeyValue<K, V>> getRecords() {
        return this.records;
    }

    public Properties getProducerProps() {
        return this.producerProps;
    }

    public String toString() {
        return "SendKeyValues(topic=" + this.getTopic() + ", records=" + this.getRecords() + ", producerProps=" + this.getProducerProps() + ")";
    }

    public SendKeyValues(String topic, Collection<KeyValue<K, V>> records, Properties producerProps) {
        this.topic = topic;
        this.records = records;
        this.producerProps = producerProps;
    }

    public static class SendKeyValuesBuilder<K, V> {
        private final String topic;
        private final Collection<KeyValue<K, V>> records = new ArrayList<KeyValue<K, V>>();
        private final Properties producerProps = new Properties();

        SendKeyValuesBuilder(String topic, Collection<KeyValue<K, V>> records) {
            this.topic = topic;
            this.records.addAll(records);
        }

        public <T> SendKeyValuesBuilder<K, V> with(String propertyName, T value) {
            this.producerProps.put(propertyName, value);
            return this;
        }

        public SendKeyValuesBuilder<K, V> withAll(Properties producerProps) {
            this.producerProps.putAll((Map<?, ?>)producerProps);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.producerProps.get(propertyName) != null) {
                return;
            }
            this.producerProps.put(propertyName, value);
        }

        public SendKeyValues<K, V> useDefaults() {
            this.producerProps.clear();
            return this.build();
        }

        public SendKeyValues<K, V> build() {
            this.ifNonExisting("key.serializer", StringSerializer.class);
            this.ifNonExisting("value.serializer", StringSerializer.class);
            this.ifNonExisting("acks", "all");
            this.ifNonExisting("retries", "1");
            return new SendKeyValues<K, V>(this.topic, this.records, this.producerProps);
        }
    }
}

