/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.StringSerializer;

public class SendValues<V> {
    private final String topic;
    private final Collection<V> values;
    private final Properties producerProps;

    public static <V> SendValuesBuilder<V> to(String topic, Collection<V> values) {
        return new SendValuesBuilder<V>(topic, values);
    }

    @SafeVarargs
    public static <V> SendValuesBuilder<V> to(String topic, V ... values) {
        return new SendValuesBuilder<V>(topic, Arrays.asList(values));
    }

    public String getTopic() {
        return this.topic;
    }

    public Collection<V> getValues() {
        return this.values;
    }

    public Properties getProducerProps() {
        return this.producerProps;
    }

    public String toString() {
        return "SendValues(topic=" + this.getTopic() + ", values=" + this.getValues() + ", producerProps=" + this.getProducerProps() + ")";
    }

    public SendValues(String topic, Collection<V> values, Properties producerProps) {
        this.topic = topic;
        this.values = values;
        this.producerProps = producerProps;
    }

    public static class SendValuesBuilder<V> {
        private final String topic;
        private final Collection<V> values = new ArrayList<V>();
        private final Properties producerProps = new Properties();

        SendValuesBuilder(String topic, Collection<V> values) {
            this.topic = topic;
            this.values.addAll(values);
        }

        public <T> SendValuesBuilder<V> with(String propertyName, T value) {
            this.producerProps.put(propertyName, value);
            return this;
        }

        public <T> SendValuesBuilder<V> withAll(Properties producerProps) {
            this.producerProps.putAll((Map<?, ?>)producerProps);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.producerProps.get(propertyName) != null) {
                return;
            }
            this.producerProps.put(propertyName, value);
        }

        public SendValues<V> useDefaults() {
            this.producerProps.clear();
            return this.build();
        }

        public SendValues<V> build() {
            this.ifNonExisting("key.serializer", StringSerializer.class);
            this.ifNonExisting("value.serializer", StringSerializer.class);
            this.ifNonExisting("acks", "all");
            this.ifNonExisting("retries", "1");
            return new SendValues<V>(this.topic, this.values, this.producerProps);
        }
    }
}

