/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TopicConfig {
    private final String topic;
    private final int numberOfPartitions;
    private final int numberOfReplicas;
    private final Properties properties;

    public Map<String, Object> getPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String propertyName : this.properties.stringPropertyNames()) {
            map.put(propertyName, this.properties.get(propertyName));
        }
        return map;
    }

    public static TopicConfigBuilder withName(String topic) {
        return new TopicConfigBuilder(topic);
    }

    public String getTopic() {
        return this.topic;
    }

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        return "TopicConfig(topic=" + this.getTopic() + ", numberOfPartitions=" + this.getNumberOfPartitions() + ", numberOfReplicas=" + this.getNumberOfReplicas() + ", properties=" + this.getProperties() + ")";
    }

    public TopicConfig(String topic, int numberOfPartitions, int numberOfReplicas, Properties properties) {
        this.topic = topic;
        this.numberOfPartitions = numberOfPartitions;
        this.numberOfReplicas = numberOfReplicas;
        this.properties = properties;
    }

    public static class TopicConfigBuilder {
        private final String topic;
        private final Properties properties = new Properties();
        private int numberOfPartitions = 1;
        private int numberOfReplicas = 1;

        TopicConfigBuilder(String topic) {
            this.topic = topic;
        }

        public TopicConfigBuilder withNumberOfPartitions(int numberOfPartitions) {
            this.numberOfPartitions = numberOfPartitions;
            return this;
        }

        public TopicConfigBuilder withNumberOfReplicas(int numberOfReplicas) {
            this.numberOfReplicas = numberOfReplicas;
            return this;
        }

        public <T> TopicConfigBuilder with(String propertyName, T value) {
            this.properties.put(propertyName, value);
            return this;
        }

        public TopicConfigBuilder withAll(Properties properties) {
            this.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.properties.get(propertyName) != null) {
                return;
            }
            this.properties.put(propertyName, value);
        }

        public TopicConfig useDefaults() {
            this.properties.clear();
            this.numberOfPartitions = 1;
            this.numberOfReplicas = 1;
            return this.build();
        }

        public TopicConfig build() {
            this.ifNonExisting("cleanup.policy", "delete");
            this.ifNonExisting("delete.retention.ms", "86400000");
            this.ifNonExisting("min.insync.replicas", "1");
            return new TopicConfig(this.topic, this.numberOfPartitions, this.numberOfReplicas, this.properties);
        }
    }
}

