/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.mguenther.kafka.junit.KeyValue;
import net.mguenther.kafka.junit.LeaderAndIsr;
import net.mguenther.kafka.junit.ObserveKeyValues;
import net.mguenther.kafka.junit.ReadKeyValues;
import net.mguenther.kafka.junit.RecordConsumer;
import net.mguenther.kafka.junit.RecordProducer;
import net.mguenther.kafka.junit.SendKeyValues;
import net.mguenther.kafka.junit.SendKeyValuesTransactional;
import net.mguenther.kafka.junit.SendValues;
import net.mguenther.kafka.junit.SendValuesTransactional;
import net.mguenther.kafka.junit.TopicConfig;
import net.mguenther.kafka.junit.TopicManager;
import net.mguenther.kafka.junit.provider.DefaultRecordConsumer;
import net.mguenther.kafka.junit.provider.DefaultRecordProducer;
import net.mguenther.kafka.junit.provider.DefaultTopicManager;
import org.apache.kafka.clients.producer.RecordMetadata;

public class ExternalKafkaCluster
implements RecordProducer,
RecordConsumer,
TopicManager {
    private final RecordProducer producerDelegate;
    private final RecordConsumer consumerDelegate;
    private final TopicManager topicManagerDelegate;

    private ExternalKafkaCluster(String bootstrapServers) {
        this.producerDelegate = new DefaultRecordProducer(bootstrapServers);
        this.consumerDelegate = new DefaultRecordConsumer(bootstrapServers);
        this.topicManagerDelegate = new DefaultTopicManager(bootstrapServers);
    }

    @Override
    public <V> List<V> readValues(ReadKeyValues<String, V> readRequest) throws InterruptedException {
        return this.consumerDelegate.readValues(readRequest);
    }

    @Override
    public <K, V> List<KeyValue<K, V>> read(ReadKeyValues<K, V> readRequest) throws InterruptedException {
        return this.consumerDelegate.read(readRequest);
    }

    @Override
    public <V> List<V> observeValues(ObserveKeyValues<String, V> observeRequest) throws InterruptedException {
        return this.consumerDelegate.observeValues(observeRequest);
    }

    @Override
    public <K, V> List<KeyValue<K, V>> observe(ObserveKeyValues<K, V> observeRequest) throws InterruptedException {
        return this.consumerDelegate.observe(observeRequest);
    }

    @Override
    public <V> List<RecordMetadata> send(SendValues<V> sendRequest) throws InterruptedException {
        return this.producerDelegate.send(sendRequest);
    }

    @Override
    public <V> List<RecordMetadata> send(SendValuesTransactional<V> sendRequest) throws InterruptedException {
        return this.producerDelegate.send(sendRequest);
    }

    @Override
    public <K, V> List<RecordMetadata> send(SendKeyValues<K, V> sendRequest) throws InterruptedException {
        return this.producerDelegate.send(sendRequest);
    }

    @Override
    public <K, V> List<RecordMetadata> send(SendKeyValuesTransactional<K, V> sendRequest) throws InterruptedException {
        return this.producerDelegate.send(sendRequest);
    }

    @Override
    public void createTopic(TopicConfig config) {
        this.topicManagerDelegate.createTopic(config);
    }

    @Override
    public void deleteTopic(String topic) {
        this.topicManagerDelegate.deleteTopic(topic);
    }

    @Override
    public boolean exists(String topic) {
        return this.topicManagerDelegate.exists(topic);
    }

    @Override
    public Map<Integer, LeaderAndIsr> fetchLeaderAndIsr(String topic) {
        return this.topicManagerDelegate.fetchLeaderAndIsr(topic);
    }

    @Override
    public Properties fetchTopicConfig(String topic) {
        return this.topicManagerDelegate.fetchTopicConfig(topic);
    }

    public static ExternalKafkaCluster at(String bootstrapServers) {
        return new ExternalKafkaCluster(bootstrapServers);
    }

    ExternalKafkaCluster(RecordProducer producerDelegate, RecordConsumer consumerDelegate, TopicManager topicManagerDelegate) {
        this.producerDelegate = producerDelegate;
        this.consumerDelegate = consumerDelegate;
        this.topicManagerDelegate = topicManagerDelegate;
    }
}

