/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.nio.charset.Charset;
import java.util.Optional;
import net.mguenther.kafka.junit.KeyValueMetadata;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class KeyValue<K, V> {
    private final K key;
    private final V value;
    private final Headers headers;
    private final KeyValueMetadata metadata;

    public KeyValue(K key, V value) {
        this(key, value, (Headers)new RecordHeaders(), null);
    }

    public KeyValue(K key, V value, Headers headers) {
        this(key, value, headers, null);
    }

    public void addHeader(String headerName, String headerValue, Charset charset) {
        this.addHeader(headerName, headerValue.getBytes(charset));
    }

    public void addHeader(String headerName, byte[] headerValue) {
        RecordHeader header = new RecordHeader(headerName, headerValue);
        this.headers.add((Header)header);
    }

    public Optional<KeyValueMetadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    public String toString() {
        return "KeyValue(key=" + this.getKey() + ", value=" + this.getValue() + ", headers=" + this.getHeaders() + ", metadata=" + this.getMetadata() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValue)) {
            return false;
        }
        KeyValue other = (KeyValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public KeyValue(K key, V value, Headers headers, KeyValueMetadata metadata) {
        this.key = key;
        this.value = value;
        this.headers = headers;
        this.metadata = metadata;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public Headers getHeaders() {
        return this.headers;
    }
}

