/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.StringDeserializer;

public class ObserveKeyValues<K, V> {
    public static final int DEFAULT_OBSERVATION_TIME_MILLIS = 30000;
    private final String topic;
    private final int expected;
    private final int observationTimeMillis;
    private final boolean includeMetadata;
    private final Map<Integer, Long> seekTo;
    private final Properties consumerProps;
    private final Predicate<K> filterOnKeys;
    private final Predicate<V> filterOnValues;
    private final Predicate<Headers> filterOnHeaders;
    private final Class<K> clazzOfK;
    private final Class<V> clazzOfV;

    public static ObserveKeyValuesBuilder<String, String> on(String topic, int expected) {
        return ObserveKeyValues.on(topic, expected, String.class, String.class);
    }

    public static <V> ObserveKeyValuesBuilder<String, V> on(String topic, int expected, Class<V> clazzOfV) {
        return ObserveKeyValues.on(topic, expected, String.class, clazzOfV);
    }

    public static <K, V> ObserveKeyValuesBuilder<K, V> on(String topic, int expected, Class<K> clazzOfK, Class<V> clazzOfV) {
        return new ObserveKeyValuesBuilder<K, V>(topic, expected, clazzOfK, clazzOfV);
    }

    public String getTopic() {
        return this.topic;
    }

    public int getExpected() {
        return this.expected;
    }

    public int getObservationTimeMillis() {
        return this.observationTimeMillis;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public Map<Integer, Long> getSeekTo() {
        return this.seekTo;
    }

    public Properties getConsumerProps() {
        return this.consumerProps;
    }

    public Predicate<K> getFilterOnKeys() {
        return this.filterOnKeys;
    }

    public Predicate<V> getFilterOnValues() {
        return this.filterOnValues;
    }

    public Predicate<Headers> getFilterOnHeaders() {
        return this.filterOnHeaders;
    }

    public Class<K> getClazzOfK() {
        return this.clazzOfK;
    }

    public Class<V> getClazzOfV() {
        return this.clazzOfV;
    }

    public String toString() {
        return "ObserveKeyValues(topic=" + this.getTopic() + ", expected=" + this.getExpected() + ", observationTimeMillis=" + this.getObservationTimeMillis() + ", includeMetadata=" + this.isIncludeMetadata() + ", seekTo=" + this.getSeekTo() + ", consumerProps=" + this.getConsumerProps() + ", filterOnKeys=" + this.getFilterOnKeys() + ", filterOnValues=" + this.getFilterOnValues() + ", filterOnHeaders=" + this.getFilterOnHeaders() + ", clazzOfK=" + this.getClazzOfK() + ", clazzOfV=" + this.getClazzOfV() + ")";
    }

    public ObserveKeyValues(String topic, int expected, int observationTimeMillis, boolean includeMetadata, Map<Integer, Long> seekTo, Properties consumerProps, Predicate<K> filterOnKeys, Predicate<V> filterOnValues, Predicate<Headers> filterOnHeaders, Class<K> clazzOfK, Class<V> clazzOfV) {
        this.topic = topic;
        this.expected = expected;
        this.observationTimeMillis = observationTimeMillis;
        this.includeMetadata = includeMetadata;
        this.seekTo = seekTo;
        this.consumerProps = consumerProps;
        this.filterOnKeys = filterOnKeys;
        this.filterOnValues = filterOnValues;
        this.filterOnHeaders = filterOnHeaders;
        this.clazzOfK = clazzOfK;
        this.clazzOfV = clazzOfV;
    }

    public static class ObserveKeyValuesBuilder<K, V> {
        private final String topic;
        private final int expected;
        private final Class<K> clazzOfK;
        private final Class<V> clazzOfV;
        private final Properties consumerProps = new Properties();
        private final Map<Integer, Long> seekTo = new HashMap<Integer, Long>();
        private Predicate<K> filterOnKeys = key -> true;
        private Predicate<V> filterOnValues = value -> true;
        private Predicate<Headers> filterOnHeaders = value -> true;
        private int observationTimeMillis = 30000;
        private boolean includeMetadata = false;

        ObserveKeyValuesBuilder(String topic, int expected, Class<K> clazzOfK, Class<V> clazzOfV) {
            this.topic = topic;
            this.expected = expected;
            this.clazzOfK = clazzOfK;
            this.clazzOfV = clazzOfV;
        }

        public ObserveKeyValuesBuilder<K, V> observeFor(int duration, TimeUnit unit) {
            this.observationTimeMillis = (int)unit.toMillis(duration);
            return this;
        }

        public ObserveKeyValuesBuilder<K, V> filterOnKeys(Predicate<K> filterOnKeys) {
            this.filterOnKeys = filterOnKeys;
            return this;
        }

        public ObserveKeyValuesBuilder<K, V> filterOnValues(Predicate<V> filterOnValues) {
            this.filterOnValues = filterOnValues;
            return this;
        }

        public ObserveKeyValuesBuilder<K, V> filterOnHeaders(Predicate<Headers> filterOnHeaders) {
            this.filterOnHeaders = filterOnHeaders;
            return this;
        }

        public ObserveKeyValuesBuilder<K, V> includeMetadata() {
            return this.withMetadata(true);
        }

        public ObserveKeyValuesBuilder<K, V> withMetadata(boolean modifier) {
            this.includeMetadata = modifier;
            return this;
        }

        public ObserveKeyValuesBuilder<K, V> seekTo(int partition, long offset) {
            this.seekTo.put(partition, offset);
            return this;
        }

        public ObserveKeyValuesBuilder<K, V> seekTo(Map<Integer, Long> seekTo) {
            this.seekTo.putAll(seekTo);
            return this;
        }

        public <T> ObserveKeyValuesBuilder<K, V> with(String propertyName, T value) {
            this.consumerProps.put(propertyName, value);
            return this;
        }

        public <T> ObserveKeyValuesBuilder<K, V> withAll(Properties consumerProps) {
            this.consumerProps.putAll((Map<?, ?>)consumerProps);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.consumerProps.get(propertyName) != null) {
                return;
            }
            this.consumerProps.put(propertyName, value);
        }

        public ObserveKeyValues<K, V> useDefaults() {
            this.consumerProps.clear();
            this.observationTimeMillis = 30000;
            return this.build();
        }

        public ObserveKeyValues<K, V> build() {
            this.ifNonExisting("group.id", UUID.randomUUID().toString());
            this.ifNonExisting("auto.offset.reset", "earliest");
            this.ifNonExisting("enable.auto.commit", false);
            this.ifNonExisting("key.deserializer", StringDeserializer.class);
            this.ifNonExisting("value.deserializer", StringDeserializer.class);
            this.ifNonExisting("max.poll.records", 100);
            this.ifNonExisting("isolation.level", "read_uncommitted");
            return new ObserveKeyValues<K, V>(this.topic, this.expected, this.observationTimeMillis, this.includeMetadata, this.seekTo, this.consumerProps, this.filterOnKeys, this.filterOnValues, this.filterOnHeaders, this.clazzOfK, this.clazzOfV);
        }
    }
}

