/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.mguenther.kafka.junit.KeyValue;
import org.apache.kafka.common.serialization.StringSerializer;

public class SendKeyValuesTransactional<K, V> {
    private final Map<String, Collection<KeyValue<K, V>>> recordsPerTopic;
    private final boolean failTransaction;
    private final Properties producerProps;

    public boolean shouldFailTransaction() {
        return this.failTransaction;
    }

    public static <K, V> SendKeyValuesTransactionalBuilder<K, V> inTransaction(String topic, Collection<KeyValue<K, V>> records) {
        return new SendKeyValuesTransactionalBuilder<K, V>(topic, records);
    }

    public static <K, V> SendKeyValuesTransactionalBuilder<K, V> inTransaction(Map<String, Collection<KeyValue<K, V>>> recordsPerTopic) {
        return new SendKeyValuesTransactionalBuilder<K, V>(recordsPerTopic);
    }

    public String toString() {
        return "SendKeyValuesTransactional(recordsPerTopic=" + this.getRecordsPerTopic() + ", failTransaction=" + this.failTransaction + ", producerProps=" + this.getProducerProps() + ")";
    }

    public SendKeyValuesTransactional(Map<String, Collection<KeyValue<K, V>>> recordsPerTopic, boolean failTransaction, Properties producerProps) {
        this.recordsPerTopic = recordsPerTopic;
        this.failTransaction = failTransaction;
        this.producerProps = producerProps;
    }

    public Map<String, Collection<KeyValue<K, V>>> getRecordsPerTopic() {
        return this.recordsPerTopic;
    }

    public Properties getProducerProps() {
        return this.producerProps;
    }

    public static class SendKeyValuesTransactionalBuilder<K, V> {
        private final Map<String, Collection<KeyValue<K, V>>> recordsPerTopic = new HashMap<String, Collection<KeyValue<K, V>>>();
        private final Properties producerProps = new Properties();
        private boolean failTransaction = false;

        SendKeyValuesTransactionalBuilder(String topic, Collection<KeyValue<K, V>> records) {
            this.recordsPerTopic.put(topic, records);
        }

        SendKeyValuesTransactionalBuilder(Map<String, Collection<KeyValue<K, V>>> recordsPerTopic) {
            this.recordsPerTopic.putAll(recordsPerTopic);
        }

        public SendKeyValuesTransactionalBuilder<K, V> inTransaction(String topic, Collection<KeyValue<K, V>> records) {
            Collection existingRecordsForTopic = this.recordsPerTopic.getOrDefault(topic, new ArrayList());
            existingRecordsForTopic.addAll(records);
            this.recordsPerTopic.put(topic, existingRecordsForTopic);
            return this;
        }

        public SendKeyValuesTransactionalBuilder<K, V> failTransaction() {
            return this.withFailTransaction(true);
        }

        public SendKeyValuesTransactionalBuilder<K, V> withFailTransaction(boolean modifier) {
            this.failTransaction = modifier;
            return this;
        }

        public <T> SendKeyValuesTransactionalBuilder<K, V> with(String propertyName, T value) {
            this.producerProps.put(propertyName, value);
            return this;
        }

        public SendKeyValuesTransactionalBuilder<K, V> withAll(Properties transactionalProps) {
            this.producerProps.putAll((Map<?, ?>)transactionalProps);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.producerProps.get(propertyName) != null) {
                return;
            }
            this.producerProps.put(propertyName, value);
        }

        public SendKeyValuesTransactional<K, V> useDefaults() {
            this.producerProps.clear();
            this.failTransaction = false;
            return this.build();
        }

        public SendKeyValuesTransactional<K, V> build() {
            this.ifNonExisting("key.serializer", StringSerializer.class);
            this.ifNonExisting("value.serializer", StringSerializer.class);
            this.ifNonExisting("retries", Integer.MAX_VALUE);
            this.ifNonExisting("max.in.flight.requests.per.connection", 1);
            this.ifNonExisting("enable.idempotence", true);
            this.ifNonExisting("transactional.id", UUID.randomUUID().toString());
            this.ifNonExisting("transaction.timeout.ms", 60000);
            this.ifNonExisting("acks", "all");
            return new SendKeyValuesTransactional<K, V>(this.recordsPerTopic, this.failTransaction, this.producerProps);
        }
    }
}

