/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.common.serialization.StringSerializer;

public class SendValuesTransactional<V> {
    private final Map<String, Collection<V>> valuesPerTopic;
    private final boolean failTransaction;
    private final Properties producerProps;

    public boolean shouldFailTransaction() {
        return this.failTransaction;
    }

    public static <V> SendValuesTransactionalBuilder<V> inTransaction(String topic, Collection<V> values) {
        return new SendValuesTransactionalBuilder<V>(topic, values);
    }

    @SafeVarargs
    public static <V> SendValuesTransactionalBuilder<V> inTransaction(String topic, V ... values) {
        return new SendValuesTransactionalBuilder<V>(topic, Arrays.asList(values));
    }

    public String toString() {
        return "SendValuesTransactional(valuesPerTopic=" + this.getValuesPerTopic() + ", failTransaction=" + this.failTransaction + ", producerProps=" + this.getProducerProps() + ")";
    }

    public SendValuesTransactional(Map<String, Collection<V>> valuesPerTopic, boolean failTransaction, Properties producerProps) {
        this.valuesPerTopic = valuesPerTopic;
        this.failTransaction = failTransaction;
        this.producerProps = producerProps;
    }

    public Map<String, Collection<V>> getValuesPerTopic() {
        return this.valuesPerTopic;
    }

    public Properties getProducerProps() {
        return this.producerProps;
    }

    public static class SendValuesTransactionalBuilder<V> {
        private final Map<String, Collection<V>> valuesPerTopic = new HashMap<String, Collection<V>>();
        private final Properties producerPros = new Properties();
        private boolean failTransaction = false;

        SendValuesTransactionalBuilder(String topic, Collection<V> values) {
            this.valuesPerTopic.put(topic, values);
        }

        public SendValuesTransactionalBuilder<V> inTransaction(String topic, Collection<V> values) {
            Collection existingValuesPerTopic = this.valuesPerTopic.getOrDefault(topic, new ArrayList());
            existingValuesPerTopic.addAll(values);
            this.valuesPerTopic.put(topic, existingValuesPerTopic);
            return this;
        }

        public SendValuesTransactionalBuilder<V> failTransaction() {
            return this.withFailTransaction(true);
        }

        public SendValuesTransactionalBuilder<V> withFailTransaction(boolean modifier) {
            this.failTransaction = modifier;
            return this;
        }

        public <T> SendValuesTransactionalBuilder<V> with(String propertyName, T value) {
            this.producerPros.put(propertyName, value);
            return this;
        }

        public <T> SendValuesTransactionalBuilder<V> withAll(Properties transactionalProps) {
            this.producerPros.putAll((Map<?, ?>)transactionalProps);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.producerPros.get(propertyName) != null) {
                return;
            }
            this.producerPros.put(propertyName, value);
        }

        public SendValuesTransactional<V> useDefaults() {
            this.producerPros.clear();
            this.failTransaction = false;
            return this.build();
        }

        public SendValuesTransactional<V> build() {
            this.ifNonExisting("key.serializer", StringSerializer.class);
            this.ifNonExisting("value.serializer", StringSerializer.class);
            this.ifNonExisting("retries", Integer.MAX_VALUE);
            this.ifNonExisting("max.in.flight.requests.per.connection", 1);
            this.ifNonExisting("enable.idempotence", true);
            this.ifNonExisting("transactional.id", UUID.randomUUID().toString());
            this.ifNonExisting("transaction.timeout.ms", 60000);
            this.ifNonExisting("acks", "all");
            return new SendValuesTransactional<V>(this.valuesPerTopic, this.failTransaction, this.producerPros);
        }
    }
}

