/*
 * Decompiled with CFR 0.152.
 */
package net.mindengine.rainbow4j.filters;

import java.awt.Rectangle;
import net.mindengine.rainbow4j.filters.ImageFilter;
import org.apache.commons.lang3.ArrayUtils;

public class BlurFilter
implements ImageFilter {
    private static final int BLOCK_SIZE = 3;
    private int radius;

    public BlurFilter(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void apply(byte[] bytes, int width, int height, Rectangle area) {
        if (area.width + area.x > width || area.height + area.y > height) {
            throw new RuntimeException("Specified area is outside of image");
        }
        if (this.radius > 1) {
            byte[] copyBytes = ArrayUtils.clone((byte[])bytes);
            for (int yc = area.y; yc < area.height; ++yc) {
                for (int xc = area.x; xc < area.width; ++xc) {
                    int startY = Math.max(yc - this.radius, 0);
                    int startX = Math.max(xc - this.radius, 0);
                    int endY = Math.min(yc + this.radius, height);
                    int endX = Math.min(xc + this.radius, width);
                    int ar = 0;
                    int ag = 0;
                    int ab = 0;
                    double sumWeight = 0.0;
                    for (int y = startY; y < endY; ++y) {
                        for (int x = startX; x < endX; ++x) {
                            int k = y * width * 3 + x * 3;
                            int r = copyBytes[k] & 0xFF;
                            int g = copyBytes[k + 1] & 0xFF;
                            int b = copyBytes[k + 2] & 0xFF;
                            double distance = Math.max(Math.abs(x - xc), Math.abs(y - yc));
                            double dWeight = 1.0 - distance / (double)(this.radius + 1);
                            sumWeight += dWeight;
                            ar = (int)((double)ar + (double)r * dWeight);
                            ag = (int)((double)ag + (double)g * dWeight);
                            ab = (int)((double)ab + (double)b * dWeight);
                        }
                    }
                    int k = yc * width * 3 + xc * 3;
                    bytes[k] = (byte)((double)ar / sumWeight);
                    bytes[k + 1] = (byte)((double)ag / sumWeight);
                    bytes[k + 2] = (byte)((double)ab / sumWeight);
                }
            }
        }
    }
}

