/*
 * Decompiled with CFR 0.152.
 */
package net.mindengine.rainbow4j.filters;

import java.awt.Rectangle;
import net.mindengine.rainbow4j.filters.ImageFilter;

public class QuantinizeFilter
implements ImageFilter {
    private int colorsAmount;

    public QuantinizeFilter(int colorsAmount) {
        this.colorsAmount = colorsAmount;
    }

    public int getColorsAmount() {
        return this.colorsAmount;
    }

    public void setColorsAmount(int colorsAmount) {
        this.colorsAmount = colorsAmount;
    }

    @Override
    public void apply(byte[] bytes, int width, int height, Rectangle area) {
        if (this.colorsAmount > 255) {
            this.colorsAmount = 255;
        } else if (this.colorsAmount < 2) {
            this.colorsAmount = 2;
        }
        int d = 256 / this.colorsAmount;
        for (int y = area.y; y < area.height; ++y) {
            for (int x = area.x; x < area.width; ++x) {
                int k = y * width * 3 + x * 3;
                double red = (bytes[k] & 0xFF) / d;
                double green = (bytes[k + 1] & 0xFF) / d;
                double blue = (bytes[k + 2] & 0xFF) / d;
                bytes[k] = (byte)(Math.ceil(red) * (double)d);
                bytes[k + 1] = (byte)(Math.ceil(green) * (double)d);
                bytes[k + 2] = (byte)(Math.ceil(blue) * (double)d);
            }
        }
    }
}

