/*
 * Decompiled with CFR 0.152.
 */
package net.mindengine.rainbow4j.filters;

import java.awt.Rectangle;
import net.mindengine.rainbow4j.filters.ImageFilter;

public class SaturationFilter
implements ImageFilter {
    private int level;

    public SaturationFilter(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void apply(byte[] bytes, int width, int height, Rectangle area) {
        if (this.level > 100) {
            this.level = 100;
        } else if (this.level < 0) {
            this.level = 0;
        }
        double t = (double)this.level / 100.0;
        for (int y = area.y; y < area.height; ++y) {
            for (int x = area.x; x < area.width; ++x) {
                int k = y * width * 3 + x * 3;
                double red = bytes[k] & 0xFF;
                double green = bytes[k + 1] & 0xFF;
                double blue = bytes[k + 2] & 0xFF;
                double gray = green * 0.59 + red * 0.3 + blue * 0.11;
                bytes[k] = (byte)this.colorRange(gray * (1.0 - t) + red * t);
                bytes[k + 1] = (byte)this.colorRange(gray * (1.0 - t) + green * t);
                bytes[k + 2] = (byte)this.colorRange(gray * (1.0 - t) + blue * t);
            }
        }
    }

    private int colorRange(double color) {
        int c = (int)color;
        if (c > 255) {
            return 255;
        }
        if (c < 0) {
            return 0;
        }
        return c;
    }
}

