/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.tag.Tag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface BlockHandler {
    default public void onPlace(@NotNull Placement placement) {
    }

    default public void onDestroy(@NotNull Destroy destroy) {
    }

    default public boolean onInteract(@NotNull Interaction interaction) {
        return true;
    }

    default public void onTouch(@NotNull Touch touch) {
    }

    default public void tick(@NotNull Tick tick) {
    }

    default public boolean isTickable() {
        return false;
    }

    @NotNull
    default public Collection<Tag<?>> getBlockEntityTags() {
        return List.of();
    }

    default public byte getBlockEntityAction() {
        return -1;
    }

    @NotNull
    public Key getKey();

    @ApiStatus.Internal
    public static final class Dummy
    implements BlockHandler {
        private static final Map<String, BlockHandler> DUMMY_CACHE = new ConcurrentHashMap<String, BlockHandler>();
        private final Key key;

        @NotNull
        public static BlockHandler get(@NotNull String namespace) {
            return DUMMY_CACHE.computeIfAbsent(namespace, Dummy::new);
        }

        private Dummy(String name) {
            this.key = Key.key((String)name);
        }

        @Override
        @NotNull
        public Key getKey() {
            return this.key;
        }
    }

    public static final class Tick {
        private final Block block;
        private final Instance instance;
        private final Point blockPosition;

        @ApiStatus.Internal
        public Tick(Block block, Instance instance, Point blockPosition) {
            this.block = block;
            this.instance = instance;
            this.blockPosition = blockPosition;
        }

        @NotNull
        public Block getBlock() {
            return this.block;
        }

        @NotNull
        public Instance getInstance() {
            return this.instance;
        }

        @NotNull
        public Point getBlockPosition() {
            return this.blockPosition;
        }
    }

    public static final class Touch {
        private final Block block;
        private final Instance instance;
        private final Point blockPosition;
        private final Entity touching;

        @ApiStatus.Internal
        public Touch(Block block, Instance instance, Point blockPosition, Entity touching) {
            this.block = block;
            this.instance = instance;
            this.blockPosition = blockPosition;
            this.touching = touching;
        }

        @NotNull
        public Block getBlock() {
            return this.block;
        }

        @NotNull
        public Instance getInstance() {
            return this.instance;
        }

        @NotNull
        public Point getBlockPosition() {
            return this.blockPosition;
        }

        @NotNull
        public Entity getTouching() {
            return this.touching;
        }
    }

    public static final class Interaction {
        private final Block block;
        private final Instance instance;
        private final BlockFace blockFace;
        private final Point blockPosition;
        private final Point cursorPosition;
        private final Player player;
        private final PlayerHand hand;

        @ApiStatus.Internal
        public Interaction(Block block, Instance instance, BlockFace blockFace, Point blockPosition, Point cursorPosition, Player player, PlayerHand hand) {
            this.block = block;
            this.instance = instance;
            this.blockFace = blockFace;
            this.blockPosition = blockPosition;
            this.cursorPosition = cursorPosition;
            this.player = player;
            this.hand = hand;
        }

        @NotNull
        public Block getBlock() {
            return this.block;
        }

        @NotNull
        public Instance getInstance() {
            return this.instance;
        }

        @NotNull
        public BlockFace getBlockFace() {
            return this.blockFace;
        }

        @NotNull
        public Point getBlockPosition() {
            return this.blockPosition;
        }

        @NotNull
        public Point getCursorPosition() {
            return this.cursorPosition;
        }

        @NotNull
        public Player getPlayer() {
            return this.player;
        }

        @NotNull
        public PlayerHand getHand() {
            return this.hand;
        }
    }

    public static final class PlayerDestroy
    extends Destroy {
        private final Player player;

        @ApiStatus.Internal
        public PlayerDestroy(Block block, Instance instance, Point blockPosition, Player player) {
            super(block, instance, blockPosition);
            this.player = player;
        }

        @NotNull
        public Player getPlayer() {
            return this.player;
        }
    }

    public static sealed class Destroy
    permits PlayerDestroy {
        private final Block block;
        private final Instance instance;
        private final Point blockPosition;

        @ApiStatus.Internal
        public Destroy(Block block, Instance instance, Point blockPosition) {
            this.block = block;
            this.instance = instance;
            this.blockPosition = blockPosition;
        }

        @NotNull
        public Block getBlock() {
            return this.block;
        }

        @NotNull
        public Instance getInstance() {
            return this.instance;
        }

        @NotNull
        public Point getBlockPosition() {
            return this.blockPosition;
        }
    }

    public static final class PlayerPlacement
    extends Placement {
        private final Player player;
        private final PlayerHand hand;
        private final BlockFace blockFace;
        private final float cursorX;
        private final float cursorY;
        private final float cursorZ;

        @ApiStatus.Internal
        public PlayerPlacement(Block block, Instance instance, Point blockPosition, Player player, PlayerHand hand, BlockFace blockFace, float cursorX, float cursorY, float cursorZ) {
            super(block, instance, blockPosition);
            this.player = player;
            this.hand = hand;
            this.blockFace = blockFace;
            this.cursorX = cursorX;
            this.cursorY = cursorY;
            this.cursorZ = cursorZ;
        }

        @NotNull
        public Player getPlayer() {
            return this.player;
        }

        @NotNull
        public PlayerHand getHand() {
            return this.hand;
        }

        @NotNull
        public BlockFace getBlockFace() {
            return this.blockFace;
        }

        public float getCursorX() {
            return this.cursorX;
        }

        public float getCursorY() {
            return this.cursorY;
        }

        public float getCursorZ() {
            return this.cursorZ;
        }
    }

    public static sealed class Placement
    permits PlayerPlacement {
        private final Block block;
        private final Instance instance;
        private final Point blockPosition;

        @ApiStatus.Internal
        public Placement(Block block, Instance instance, Point blockPosition) {
            this.block = block;
            this.instance = instance;
            this.blockPosition = blockPosition;
        }

        @NotNull
        public Block getBlock() {
            return this.block;
        }

        @NotNull
        public Instance getInstance() {
            return this.instance;
        }

        @NotNull
        public Point getBlockPosition() {
            return this.blockPosition;
        }
    }
}

