/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.Map;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.EntityEquipmentPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public interface EquipmentHandler {
    @NotNull
    public ItemStack getEquipment(@NotNull EquipmentSlot var1);

    public void setEquipment(@NotNull EquipmentSlot var1, @NotNull ItemStack var2);

    @NotNull
    default public ItemStack getItemInMainHand() {
        return this.getEquipment(EquipmentSlot.MAIN_HAND);
    }

    default public void setItemInMainHand(@NotNull ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.MAIN_HAND, itemStack);
    }

    @NotNull
    default public ItemStack getItemInOffHand() {
        return this.getEquipment(EquipmentSlot.OFF_HAND);
    }

    default public void setItemInOffHand(@NotNull ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.OFF_HAND, itemStack);
    }

    @NotNull
    default public ItemStack getItemInHand(@NotNull PlayerHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case PlayerHand.MAIN -> this.getItemInMainHand();
            case PlayerHand.OFF -> this.getItemInOffHand();
        };
    }

    default public void setItemInHand(@NotNull PlayerHand hand, @NotNull ItemStack stack) {
        switch (hand) {
            case MAIN: {
                this.setItemInMainHand(stack);
                break;
            }
            case OFF: {
                this.setItemInOffHand(stack);
            }
        }
    }

    @NotNull
    default public ItemStack getHelmet() {
        return this.getEquipment(EquipmentSlot.HELMET);
    }

    default public void setHelmet(@NotNull ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.HELMET, itemStack);
    }

    @NotNull
    default public ItemStack getChestplate() {
        return this.getEquipment(EquipmentSlot.CHESTPLATE);
    }

    default public void setChestplate(@NotNull ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.CHESTPLATE, itemStack);
    }

    @NotNull
    default public ItemStack getLeggings() {
        return this.getEquipment(EquipmentSlot.LEGGINGS);
    }

    default public void setLeggings(@NotNull ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.LEGGINGS, itemStack);
    }

    @NotNull
    default public ItemStack getBoots() {
        return this.getEquipment(EquipmentSlot.BOOTS);
    }

    default public void setBoots(@NotNull ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.BOOTS, itemStack);
    }

    @NotNull
    default public ItemStack getBodyEquipment() {
        return this.getEquipment(EquipmentSlot.BODY);
    }

    default public void setBodyEquipment(@NotNull ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.BODY, itemStack);
    }

    default public boolean hasEquipment(@NotNull EquipmentSlot slot) {
        return !this.getEquipment(slot).isAir();
    }

    default public void syncEquipment(@NotNull EquipmentSlot slot) {
        this.syncEquipment(slot, this.getEquipment(slot));
    }

    default public void syncEquipment(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        Check.stateCondition(!(this instanceof Entity), "Only accessible for Entity");
        Entity entity = (Entity)((Object)this);
        entity.sendPacketToViewers(new EntityEquipmentPacket(entity.getEntityId(), Map.of(slot, stack)));
    }

    @NotNull
    default public EntityEquipmentPacket getEquipmentsPacket() {
        Check.stateCondition(!(this instanceof Entity), "Only accessible for Entity");
        return new EntityEquipmentPacket(((Entity)((Object)this)).getEntityId(), Map.of(EquipmentSlot.MAIN_HAND, this.getItemInMainHand(), EquipmentSlot.OFF_HAND, this.getItemInOffHand(), EquipmentSlot.BOOTS, this.getBoots(), EquipmentSlot.LEGGINGS, this.getLeggings(), EquipmentSlot.CHESTPLATE, this.getChestplate(), EquipmentSlot.HELMET, this.getHelmet(), EquipmentSlot.BODY, this.getBodyEquipment()));
    }
}

