/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.click;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryClickEvent;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.inventory.condition.InventoryCondition;
import net.minestom.server.inventory.condition.InventoryConditionResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InventoryClickProcessor {
    private final Map<Player, List<DragData>> leftDraggingMap = new ConcurrentHashMap<Player, List<DragData>>();
    private final Map<Player, List<DragData>> rightDraggingMap = new ConcurrentHashMap<Player, List<DragData>>();

    @NotNull
    public InventoryClickResult leftClick(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult result = this.startCondition(player, inventory, slot, ClickType.LEFT_CLICK, clicked, cursor);
        if (result.isCancel()) {
            return result;
        }
        clicked = result.getClicked();
        cursor = result.getCursor();
        if (cursor.isSimilar(clicked)) {
            int totalAmount = cursor.amount() + clicked.amount();
            int maxSize = cursor.maxStackSize();
            if (!MathUtils.isBetween(totalAmount, 0, clicked.maxStackSize())) {
                result.setCursor(cursor.withAmount(totalAmount - maxSize));
                result.setClicked(clicked.withAmount(maxSize));
            } else {
                result.setCursor(ItemStack.AIR);
                result.setClicked(clicked.withAmount(totalAmount));
            }
        } else {
            result.setCursor(clicked);
            result.setClicked(cursor);
        }
        return result;
    }

    @NotNull
    public InventoryClickResult rightClick(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult result = this.startCondition(player, inventory, slot, ClickType.RIGHT_CLICK, clicked, cursor);
        if (result.isCancel()) {
            return result;
        }
        clicked = result.getClicked();
        if (clicked.isSimilar(cursor = result.getCursor())) {
            int amount = clicked.amount() + 1;
            if (!MathUtils.isBetween(amount, 0, clicked.maxStackSize())) {
                return result;
            }
            result.setCursor(cursor.withAmount(operand -> operand - 1));
            result.setClicked(clicked.withAmount(amount));
        } else if (cursor.isAir()) {
            int amount = (int)Math.ceil((double)clicked.amount() / 2.0);
            result.setCursor(clicked.withAmount(amount));
            result.setClicked(clicked.withAmount(operand -> operand / 2));
        } else if (clicked.isAir()) {
            result.setCursor(cursor.withAmount(operand -> operand - 1));
            result.setClicked(cursor.withAmount(1));
        } else {
            result.setCursor(clicked);
            result.setClicked(cursor);
        }
        return result;
    }

    @NotNull
    public InventoryClickResult changeHeld(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, int key, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = this.startCondition(player, inventory, slot, ClickType.CHANGE_HELD, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        clickResult = this.startCondition(player, player.getInventory(), key, ClickType.CHANGE_HELD, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        clickResult.setClicked(cursor);
        clickResult.setCursor(clicked);
        return clickResult;
    }

    @NotNull
    public InventoryClickResult shiftClick(@NotNull AbstractInventory inventory, @NotNull AbstractInventory targetInventory, int start, int end, int step, @NotNull Player player, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        ItemStack currentArmor;
        Material material;
        EquipmentSlot equipmentSlot;
        InventoryClickResult clickResult = this.startCondition(player, inventory, slot, ClickType.START_SHIFT_CLICK, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        if (clicked.isAir()) {
            return clickResult.cancelled();
        }
        if (inventory instanceof PlayerInventory && targetInventory instanceof PlayerInventory && (equipmentSlot = (material = clicked.material()).registry().equipmentSlot()) != null && (currentArmor = player.getEquipment(equipmentSlot)).isAir()) {
            int armorSlot = equipmentSlot.armorSlot();
            InventoryClickResult result = this.startCondition(player, targetInventory, armorSlot, ClickType.SHIFT_CLICK, clicked, cursor);
            if (result.isCancel()) {
                return clickResult;
            }
            result.setClicked(ItemStack.AIR);
            result.setCursor(cursor);
            player.setEquipment(equipmentSlot, clicked);
            return result;
        }
        clickResult.setCancel(true);
        Pair<ItemStack, Map<Integer, ItemStack>> pair = TransactionType.ADD.process(targetInventory, clicked, (index, itemStack) -> {
            if (inventory == targetInventory && index == slot) {
                return false;
            }
            InventoryClickResult result = this.startCondition(player, targetInventory, index, ClickType.SHIFT_CLICK, itemStack, cursor);
            if (result.isCancel()) {
                return false;
            }
            clickResult.setCancel(false);
            return true;
        }, start, end, step);
        ItemStack itemResult = (ItemStack)pair.left();
        Map itemChangesMap = (Map)pair.right();
        itemChangesMap.forEach((s, itemStack) -> {
            targetInventory.setItemStack((int)s, (ItemStack)itemStack);
            this.callClickEvent(player, targetInventory, (int)s, ClickType.SHIFT_CLICK, (ItemStack)itemStack, cursor);
        });
        clickResult.setClicked(itemResult);
        return clickResult;
    }

    @Nullable
    public InventoryClickResult dragging(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, int button, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = null;
        if (slot != -999) {
            if (button == 1) {
                List<DragData> left = this.leftDraggingMap.get(player);
                if (left == null) {
                    return null;
                }
                left.add(new DragData(slot, inventory));
            } else if (button == 5) {
                List<DragData> right = this.rightDraggingMap.get(player);
                if (right == null) {
                    return null;
                }
                right.add(new DragData(slot, inventory));
            } else if (button == 9) {
                // empty if block
            }
        } else if (button == 0) {
            clickResult = this.startCondition(player, inventory, slot, ClickType.START_LEFT_DRAGGING, clicked, cursor);
            if (!clickResult.isCancel()) {
                this.leftDraggingMap.put(player, new ArrayList());
            }
        } else if (button == 2) {
            int cursorAmount;
            List<DragData> slots = this.leftDraggingMap.remove(player);
            if (slots == null) {
                return null;
            }
            int slotCount = slots.size();
            if (slotCount > (cursorAmount = cursor.amount())) {
                return null;
            }
            for (DragData s : slots) {
                ItemStack slotItem = s.inventory.getItemStack(s.slot);
                clickResult = this.startCondition(player, s.inventory, s.slot, ClickType.LEFT_DRAGGING, slotItem, cursor);
                if (!clickResult.isCancel()) continue;
                return clickResult;
            }
            clickResult = this.startCondition(player, inventory, slot, ClickType.END_LEFT_DRAGGING, clicked, cursor);
            if (clickResult.isCancel()) {
                return clickResult;
            }
            int slotSize = (int)((float)cursorAmount / (float)slotCount);
            int finalCursorAmount = cursorAmount;
            for (DragData dragData : slots) {
                AbstractInventory inv = dragData.inventory;
                int s = dragData.slot;
                ItemStack slotItem = inv.getItemStack(s);
                int amount = slotItem.amount();
                if (cursor.isSimilar(slotItem)) {
                    if (MathUtils.isBetween(amount + slotSize, 0, slotItem.maxStackSize())) {
                        slotItem = slotItem.withAmount(a -> a + slotSize);
                        finalCursorAmount -= slotSize;
                    } else {
                        int maxSize = cursor.maxStackSize();
                        int removedAmount = maxSize - amount;
                        slotItem = slotItem.withAmount(maxSize);
                        finalCursorAmount -= removedAmount;
                    }
                } else if (slotItem.isAir()) {
                    slotItem = cursor.withAmount(slotSize);
                    finalCursorAmount -= slotSize;
                }
                inv.setItemStack(s, slotItem);
                this.callClickEvent(player, inv, s, ClickType.LEFT_DRAGGING, slotItem, cursor);
            }
            clickResult.setCursor(cursor.withAmount(finalCursorAmount));
        } else if (button == 4) {
            clickResult = this.startCondition(player, inventory, slot, ClickType.START_RIGHT_DRAGGING, clicked, cursor);
            if (!clickResult.isCancel()) {
                this.rightDraggingMap.put(player, new ArrayList());
            }
        } else if (button == 6) {
            int cursorAmount;
            List<DragData> slots = this.rightDraggingMap.remove(player);
            if (slots == null) {
                return null;
            }
            int size = slots.size();
            if (size > (cursorAmount = cursor.amount())) {
                return null;
            }
            for (DragData s : slots) {
                ItemStack slotItem = s.inventory.getItemStack(s.slot);
                clickResult = this.startCondition(player, s.inventory, s.slot, ClickType.RIGHT_DRAGGING, slotItem, cursor);
                if (!clickResult.isCancel()) continue;
                return clickResult;
            }
            clickResult = this.startCondition(player, inventory, slot, ClickType.END_RIGHT_DRAGGING, clicked, cursor);
            if (clickResult.isCancel()) {
                return clickResult;
            }
            int finalCursorAmount = cursorAmount;
            for (DragData dragData : slots) {
                AbstractInventory inv = dragData.inventory;
                int s = dragData.slot;
                ItemStack slotItem = inv.getItemStack(s);
                if (cursor.isSimilar(slotItem)) {
                    int amount = slotItem.amount() + 1;
                    if (MathUtils.isBetween(amount, 0, slotItem.maxStackSize())) {
                        slotItem = slotItem.withAmount(amount);
                        --finalCursorAmount;
                    }
                } else if (slotItem.isAir()) {
                    slotItem = cursor.withAmount(1);
                    --finalCursorAmount;
                }
                inv.setItemStack(s, slotItem);
                this.callClickEvent(player, inv, s, ClickType.RIGHT_DRAGGING, slotItem, cursor);
            }
            clickResult.setCursor(cursor.withAmount(finalCursorAmount));
        }
        return clickResult;
    }

    @NotNull
    public InventoryClickResult doubleClick(@NotNull AbstractInventory clickedInventory, @NotNull AbstractInventory inventory, @NotNull Player player, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = this.startCondition(player, clickedInventory, slot, ClickType.START_DOUBLE_CLICK, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        if (cursor.isAir()) {
            return clickResult.cancelled();
        }
        int amount = cursor.amount();
        int maxSize = cursor.maxStackSize();
        int remainingAmount = maxSize - amount;
        if (remainingAmount == 0) {
            return clickResult;
        }
        BiFunction<AbstractInventory, ItemStack, ItemStack> func = (inv, rest) -> {
            Pair<ItemStack, Map<Integer, ItemStack>> pair = TransactionType.TAKE.process((AbstractInventory)inv, (ItemStack)rest, (index, itemStack) -> {
                if (index == slot) {
                    return false;
                }
                InventoryClickResult result = this.startCondition(player, (AbstractInventory)inv, index, ClickType.DOUBLE_CLICK, itemStack, cursor);
                return !result.isCancel();
            });
            ItemStack itemResult = (ItemStack)pair.left();
            Map itemChangesMap = (Map)pair.right();
            itemChangesMap.forEach((s, itemStack) -> {
                inv.setItemStack((int)s, (ItemStack)itemStack);
                this.callClickEvent(player, (AbstractInventory)inv, (int)s, ClickType.DOUBLE_CLICK, (ItemStack)itemStack, cursor);
            });
            return itemResult;
        };
        ItemStack remain = cursor.withAmount(remainingAmount);
        PlayerInventory playerInventory = player.getInventory();
        if (Objects.equals(clickedInventory, inventory)) {
            if (!(remain = func.apply(inventory, remain)).isAir()) {
                remain = func.apply(playerInventory, remain);
            }
        } else if (clickedInventory == playerInventory) {
            if (!(remain = func.apply(playerInventory, remain)).isAir()) {
                remain = func.apply(inventory, remain);
            }
        } else {
            remain = func.apply(playerInventory, remain);
        }
        if (remain.isAir()) {
            clickResult.setCursor(cursor.withAmount(maxSize));
        } else {
            int tookAmount = remainingAmount - remain.amount();
            clickResult.setCursor(cursor.withAmount(amount + tookAmount));
        }
        return clickResult;
    }

    @NotNull
    public InventoryClickResult drop(@NotNull Player player, @NotNull AbstractInventory inventory, boolean all, int slot, int button, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = this.startCondition(player, inventory, slot, ClickType.DROP, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        ItemStack resultClicked = clicked;
        ItemStack resultCursor = cursor;
        if (slot == -999) {
            if (button == 0) {
                int amount = resultCursor.amount();
                ItemStack dropItem = resultCursor.withAmount(amount);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    resultCursor = ItemStack.AIR;
                }
            } else if (button == 1) {
                ItemStack dropItem = resultCursor.withAmount(1);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    int amount = resultCursor.amount();
                    int newAmount = amount - 1;
                    resultCursor = resultCursor.withAmount(newAmount);
                }
            }
        } else if (!all) {
            if (button == 0) {
                ItemStack dropItem = resultClicked.withAmount(1);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    int amount = resultClicked.amount();
                    int newAmount = amount - 1;
                    resultClicked = resultClicked.withAmount(newAmount);
                }
            } else if (button == 1) {
                int amount = resultClicked.amount();
                ItemStack dropItem = resultClicked.withAmount(amount);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    resultClicked = ItemStack.AIR;
                }
            }
        }
        clickResult.setClicked(resultClicked);
        clickResult.setCursor(resultCursor);
        return clickResult;
    }

    @NotNull
    private InventoryClickResult startCondition(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, @NotNull ClickType clickType, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        List<InventoryCondition> inventoryConditions;
        InventoryClickResult clickResult = new InventoryClickResult(clicked, cursor);
        player.UNSAFE_changeDidCloseInventory(false);
        InventoryPreClickEvent inventoryPreClickEvent = new InventoryPreClickEvent(inventory, player, slot, clickType, clickResult.getClicked(), clickResult.getCursor());
        EventDispatcher.call(inventoryPreClickEvent);
        clickResult.setCursor(inventoryPreClickEvent.getCursorItem());
        clickResult.setClicked(inventoryPreClickEvent.getClickedItem());
        if (inventoryPreClickEvent.isCancelled()) {
            clickResult.setCancel(true);
        }
        if (!(inventoryConditions = inventory.getInventoryConditions()).isEmpty()) {
            for (InventoryCondition inventoryCondition : inventoryConditions) {
                InventoryConditionResult result = new InventoryConditionResult(clickResult.getClicked(), clickResult.getCursor());
                inventoryCondition.accept(player, slot, clickType, result);
                clickResult.setCursor(result.getCursorItem());
                clickResult.setClicked(result.getClickedItem());
                if (!result.isCancel()) continue;
                clickResult.setCancel(true);
            }
            if (player.didCloseInventory()) {
                clickResult.setCancel(true);
                player.UNSAFE_changeDidCloseInventory(false);
            }
        }
        return clickResult;
    }

    private void callClickEvent(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, @NotNull ClickType clickType, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        EventDispatcher.call(new InventoryClickEvent(inventory, player, slot, clickType, clicked, cursor));
    }

    public void clearCache(@NotNull Player player) {
        this.leftDraggingMap.remove(player);
        this.rightDraggingMap.remove(player);
    }

    private record DragData(int slot, AbstractInventory inventory) {
    }
}

