/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.instrument;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.Registry;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.nbt.BinaryTagTemplate;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstrumentImpl
extends Record
implements Instrument {
    @NotNull
    private final SoundEvent soundEvent;
    private final float useDuration;
    private final float range;
    @NotNull
    private final Component description;
    @Nullable
    private final Registry.InstrumentEntry registry;
    static final NetworkBuffer.Type<Instrument> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(SoundEvent.NETWORK_TYPE, Instrument::soundEvent, NetworkBuffer.FLOAT, Instrument::useDuration, NetworkBuffer.FLOAT, Instrument::range, NetworkBuffer.COMPONENT, Instrument::description, InstrumentImpl::new);
    static final BinaryTagSerializer<Instrument> REGISTRY_NBT_TYPE = BinaryTagTemplate.object("sound_event", SoundEvent.NBT_TYPE, Instrument::soundEvent, "use_duration", BinaryTagSerializer.FLOAT, Instrument::useDuration, "range", BinaryTagSerializer.FLOAT, Instrument::range, "description", BinaryTagSerializer.NBT_COMPONENT, Instrument::description, InstrumentImpl::new);

    public InstrumentImpl(@NotNull SoundEvent soundEvent, float useDuration, float range, @NotNull Component description, @Nullable Registry.InstrumentEntry registry) {
        Check.argCondition(soundEvent == null, "missing sound event");
        Check.argCondition(description == null, "missing description");
        Check.argCondition(useDuration <= 0.0f, "use duration must be positive");
        Check.argCondition(range <= 0.0f, "range must be positive");
        this.soundEvent = soundEvent;
        this.useDuration = useDuration;
        this.range = range;
        this.description = description;
        this.registry = registry;
    }

    public InstrumentImpl(@NotNull SoundEvent soundEvent, float useDuration, float range, @NotNull Component description) {
        this(soundEvent, useDuration, range, description, null);
    }

    public InstrumentImpl(@NotNull Registry.InstrumentEntry registry) {
        this(registry.soundEvent(), registry.useDuration(), registry.range(), registry.description(), registry);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{InstrumentImpl.class, "soundEvent;useDuration;range;description;registry", "soundEvent", "useDuration", "range", "description", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InstrumentImpl.class, "soundEvent;useDuration;range;description;registry", "soundEvent", "useDuration", "range", "description", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InstrumentImpl.class, "soundEvent;useDuration;range;description;registry", "soundEvent", "useDuration", "range", "description", "registry"}, this, o);
    }

    @Override
    @NotNull
    public SoundEvent soundEvent() {
        return this.soundEvent;
    }

    @Override
    public float useDuration() {
        return this.useDuration;
    }

    @Override
    public float range() {
        return this.range;
    }

    @Override
    @NotNull
    public Component description() {
        return this.description;
    }

    @Override
    @Nullable
    public Registry.InstrumentEntry registry() {
        return this.registry;
    }
}

