/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.registry.DynamicRegistryImpl;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DynamicRegistry<T>
permits DynamicRegistryImpl {
    @ApiStatus.Internal
    @NotNull
    public static <T> DynamicRegistry<T> create(@NotNull String id) {
        return new DynamicRegistryImpl(id, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> DynamicRegistry<T> create(@NotNull String id, @NotNull BinaryTagSerializer<T> nbtType) {
        return new DynamicRegistryImpl<T>(id, nbtType);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends ProtocolObject> DynamicRegistry<T> create(@NotNull String id, @NotNull BinaryTagSerializer<T> nbtType, @NotNull Registry.Resource resource, @NotNull Registry.Container.Loader<T> loader) {
        return DynamicRegistry.create(id, nbtType, resource, loader, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends ProtocolObject> DynamicRegistry<T> create(@NotNull String id, @NotNull BinaryTagSerializer<T> nbtType, @NotNull Registry.Resource resource, @NotNull Registry.Container.Loader<T> loader, @Nullable Comparator<String> idComparator) {
        DynamicRegistryImpl<T> registry = new DynamicRegistryImpl<T>(id, nbtType);
        DynamicRegistryImpl.loadStaticRegistry(registry, resource, loader, idComparator);
        return registry;
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends ProtocolObject> DynamicRegistry<T> create(@NotNull String id, @NotNull BinaryTagSerializer<T> nbtType, @NotNull Registries registries, @NotNull Registry.Resource resource) {
        DynamicRegistryImpl<T> registry = new DynamicRegistryImpl<T>(id, nbtType);
        DynamicRegistryImpl.loadStaticSnbtRegistry(registries, registry, resource);
        return registry;
    }

    @NotNull
    public String id();

    @Nullable
    public T get(int var1);

    @Nullable
    public T get(@NotNull net.kyori.adventure.key.Key var1);

    @Nullable
    default public T get(@NotNull Key<T> key) {
        return this.get(key.key());
    }

    @Nullable
    public Key<T> getKey(int var1);

    @Nullable
    public Key<T> getKey(@NotNull T var1);

    @Nullable
    public net.kyori.adventure.key.Key getName(int var1);

    @Nullable
    public DataPack getPack(int var1);

    @Nullable
    default public DataPack getPack(@NotNull Key<T> key) {
        int id = this.getId(key);
        return id == -1 ? null : this.getPack(id);
    }

    public int getId(@NotNull net.kyori.adventure.key.Key var1);

    default public int getId(@NotNull Key<T> key) {
        return this.getId(key.key());
    }

    @NotNull
    public List<T> values();

    @NotNull
    default public Key<T> register(@NotNull String id, @NotNull T object) {
        return this.register(net.kyori.adventure.key.Key.key((String)id), object, null);
    }

    @NotNull
    default public Key<T> register(@NotNull net.kyori.adventure.key.Key id, @NotNull T object) {
        return this.register(id, object, null);
    }

    @ApiStatus.Internal
    @NotNull
    default public Key<T> register(@NotNull String id, @NotNull T object, @Nullable DataPack pack) {
        return this.register(net.kyori.adventure.key.Key.key((String)id), object, pack);
    }

    @ApiStatus.Internal
    @NotNull
    default public Key<T> register(@NotNull net.kyori.adventure.key.Key id, @NotNull T object, @Nullable DataPack pack) {
        return this.register(id, object);
    }

    public boolean remove(@NotNull net.kyori.adventure.key.Key var1) throws UnsupportedOperationException;

    @ApiStatus.Internal
    @NotNull
    public SendablePacket registryDataPacket(@NotNull Registries var1, boolean var2);

    public static sealed interface Key<T>
    extends Keyed
    permits DynamicRegistryImpl.KeyImpl {
        @NotNull
        public static <T> Key<T> of(@NotNull String namespace) {
            return new DynamicRegistryImpl.KeyImpl(net.kyori.adventure.key.Key.key((String)namespace));
        }

        @NotNull
        public static <T> Key<T> of(@NotNull net.kyori.adventure.key.Key key) {
            return new DynamicRegistryImpl.KeyImpl(key);
        }

        @Contract(pure=true)
        @NotNull
        public net.kyori.adventure.key.Key key();

        @Contract(pure=true)
        @NotNull
        default public String name() {
            return this.key().asString();
        }
    }
}

