/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Collection;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ObjectSetImpl;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public sealed interface ObjectSet<T extends ProtocolObject>
permits ObjectSetImpl {
    @NotNull
    public static <T extends ProtocolObject> ObjectSet<T> empty() {
        return ObjectSetImpl.Empty.INSTANCE;
    }

    @NotNull
    public static <T extends ProtocolObject> ObjectSet<T> of(@NotNull Collection<Key> entries) {
        return new ObjectSetImpl.Entries(List.copyOf(entries));
    }

    @NotNull
    public static <T extends ProtocolObject> ObjectSet<T> of(@NotNull Tag tag) {
        return new ObjectSetImpl.Tag(tag);
    }

    public static <T extends ProtocolObject> @NotNull NetworkBuffer.Type<ObjectSet<T>> networkType(@NotNull Tag.BasicType tagType) {
        return new ObjectSetImpl.NetworkType(tagType);
    }

    @NotNull
    public static <T extends ProtocolObject> BinaryTagSerializer<ObjectSet<T>> nbtType(@NotNull Tag.BasicType tagType) {
        return new ObjectSetImpl.NbtType(tagType);
    }

    default public boolean contains(@NotNull StaticProtocolObject object) {
        return this.contains(object.key());
    }

    default public boolean contains(@NotNull DynamicRegistry.Key<T> key) {
        return this.contains(key.key());
    }

    public boolean contains(@NotNull Key var1);
}

