/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.nbt.BinaryTagUtil;

final class TagNbtSeparator {
    static final Map<BinaryTagType<?>, Function<String, Tag<?>>> SUPPORTED_TYPES = Map.ofEntries(Map.entry(BinaryTagTypes.BYTE, Tag::Byte), Map.entry(BinaryTagTypes.SHORT, Tag::Short), Map.entry(BinaryTagTypes.INT, Tag::Integer), Map.entry(BinaryTagTypes.LONG, Tag::Long), Map.entry(BinaryTagTypes.FLOAT, Tag::Float), Map.entry(BinaryTagTypes.DOUBLE, Tag::Double), Map.entry(BinaryTagTypes.STRING, Tag::String));

    TagNbtSeparator() {
    }

    static void separate(CompoundBinaryTag nbtCompound, Consumer<Entry> consumer) {
        for (Map.Entry ent : nbtCompound) {
            TagNbtSeparator.convert(new ArrayList<String>(), (String)ent.getKey(), (BinaryTag)ent.getValue(), consumer);
        }
    }

    static void separate(String key, BinaryTag nbt, Consumer<Entry> consumer) {
        TagNbtSeparator.convert(new ArrayList<String>(), key, nbt, consumer);
    }

    static Entry separateSingle(String key, BinaryTag nbt) {
        assert (!(nbt instanceof CompoundBinaryTag));
        AtomicReference entryRef = new AtomicReference();
        TagNbtSeparator.convert(new ArrayList<String>(), key, nbt, entry -> {
            assert (entryRef.getPlain() == null) : "Multiple entries found for nbt tag: " + key + " -> " + String.valueOf(nbt);
            entryRef.setPlain(entry);
        });
        Entry entry2 = (Entry)entryRef.getPlain();
        assert (entry2 != null);
        return entry2;
    }

    private static void convert(List<String> path, String key, BinaryTag nbt, Consumer<Entry> consumer) {
        Function<String, Tag<?>> tagFunction = SUPPORTED_TYPES.get(nbt.type());
        if (tagFunction != null) {
            Tag<?> tag = tagFunction.apply(key);
            consumer.accept(TagNbtSeparator.makeEntry(path, tag, BinaryTagUtil.nbtValueFromTag(nbt)));
        } else if (nbt instanceof CompoundBinaryTag) {
            CompoundBinaryTag nbtCompound = (CompoundBinaryTag)nbt;
            for (Map.Entry ent : nbtCompound) {
                ArrayList<String> newPath = new ArrayList<String>(path);
                newPath.add(key);
                TagNbtSeparator.convert(newPath, (String)ent.getKey(), (BinaryTag)ent.getValue(), consumer);
            }
        } else if (nbt instanceof ListBinaryTag) {
            ListBinaryTag nbtList = (ListBinaryTag)nbt;
            tagFunction = SUPPORTED_TYPES.get(nbtList.elementType());
            if (tagFunction == null) {
                consumer.accept(TagNbtSeparator.makeEntry(path, Tag.NBT(key), nbt));
            } else {
                try {
                    Tag<List<?>> tag = tagFunction.apply(key).list();
                    Object[] values = new Object[nbtList.size()];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = BinaryTagUtil.nbtValueFromTag(nbtList.get(i));
                    }
                    consumer.accept(TagNbtSeparator.makeEntry(path, (Tag)Tag.class.cast(tag), List.of(values)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    consumer.accept(TagNbtSeparator.makeEntry(path, Tag.NBT(key), nbt));
                }
            }
        } else {
            consumer.accept(TagNbtSeparator.makeEntry(path, Tag.NBT(key), nbt));
        }
    }

    private static <T> Entry<?> makeEntry(List<String> path, Tag<T> tag, T value) {
        return new Entry<T>(tag.path((String[])path.toArray(String[]::new)), value);
    }

    record Entry<T>(Tag<T> tag, T value) {
    }
}

