/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerProcess;
import net.minestom.server.advancements.AdvancementManager;
import net.minestom.server.adventure.bossbar.BossBarManager;
import net.minestom.server.command.CommandManager;
import net.minestom.server.entity.Entity;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.event.server.ServerTickMonitorEvent;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.gamedata.tags.TagManager;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceManager;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.item.armor.TrimManager;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.monitoring.BenchmarkManager;
import net.minestom.server.monitoring.TickMonitor;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.PacketProcessor;
import net.minestom.server.network.socket.Server;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.scoreboard.TeamManager;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.ServerSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.PropertyUtils;
import net.minestom.server.utils.collection.MappedCollection;
import net.minestom.server.world.DimensionTypeManager;
import net.minestom.server.world.biomes.BiomeManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerProcessImpl
implements ServerProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerProcessImpl.class);
    private static final Boolean SHUTDOWN_ON_SIGNAL = PropertyUtils.getBoolean("minestom.shutdown-on-signal", true);
    private final ExceptionManager exception;
    private final ConnectionManager connection;
    private final PacketListenerManager packetListener;
    private final PacketProcessor packetProcessor;
    private final InstanceManager instance;
    private final BlockManager block;
    private final CommandManager command;
    private final RecipeManager recipe;
    private final TeamManager team;
    private final GlobalEventHandler eventHandler;
    private final SchedulerManager scheduler;
    private final BenchmarkManager benchmark;
    private final DimensionTypeManager dimension;
    private final BiomeManager biome;
    private final AdvancementManager advancement;
    private final BossBarManager bossBar;
    private final TagManager tag;
    private final TrimManager trim;
    private final Server server;
    private final ThreadDispatcher<Chunk> dispatcher;
    private final ServerProcess.Ticker ticker;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();

    public ServerProcessImpl() throws IOException {
        this.exception = new ExceptionManager();
        this.connection = new ConnectionManager();
        this.packetListener = new PacketListenerManager();
        this.packetProcessor = new PacketProcessor(this.packetListener);
        this.instance = new InstanceManager();
        this.block = new BlockManager();
        this.command = new CommandManager();
        this.recipe = new RecipeManager();
        this.team = new TeamManager();
        this.eventHandler = new GlobalEventHandler();
        this.scheduler = new SchedulerManager();
        this.benchmark = new BenchmarkManager();
        this.dimension = new DimensionTypeManager();
        this.biome = new BiomeManager();
        this.advancement = new AdvancementManager();
        this.bossBar = new BossBarManager();
        this.tag = new TagManager();
        this.trim = new TrimManager();
        this.server = new Server(this.packetProcessor);
        this.dispatcher = ThreadDispatcher.singleThread();
        this.ticker = new TickerImpl();
    }

    @Override
    @NotNull
    public ConnectionManager connection() {
        return this.connection;
    }

    @Override
    @NotNull
    public InstanceManager instance() {
        return this.instance;
    }

    @Override
    @NotNull
    public BlockManager block() {
        return this.block;
    }

    @Override
    @NotNull
    public CommandManager command() {
        return this.command;
    }

    @Override
    @NotNull
    public RecipeManager recipe() {
        return this.recipe;
    }

    @Override
    @NotNull
    public TeamManager team() {
        return this.team;
    }

    @Override
    @NotNull
    public GlobalEventHandler eventHandler() {
        return this.eventHandler;
    }

    @Override
    @NotNull
    public SchedulerManager scheduler() {
        return this.scheduler;
    }

    @Override
    @NotNull
    public BenchmarkManager benchmark() {
        return this.benchmark;
    }

    @Override
    @NotNull
    public DimensionTypeManager dimension() {
        return this.dimension;
    }

    @Override
    @NotNull
    public BiomeManager biome() {
        return this.biome;
    }

    @Override
    @NotNull
    public AdvancementManager advancement() {
        return this.advancement;
    }

    @Override
    @NotNull
    public BossBarManager bossBar() {
        return this.bossBar;
    }

    @Override
    @NotNull
    public TagManager tag() {
        return this.tag;
    }

    @Override
    @NotNull
    public TrimManager trim() {
        return this.trim;
    }

    @Override
    @NotNull
    public ExceptionManager exception() {
        return this.exception;
    }

    @Override
    @NotNull
    public PacketListenerManager packetListener() {
        return this.packetListener;
    }

    @Override
    @NotNull
    public PacketProcessor packetProcessor() {
        return this.packetProcessor;
    }

    @Override
    @NotNull
    public Server server() {
        return this.server;
    }

    @Override
    @NotNull
    public ThreadDispatcher<Chunk> dispatcher() {
        return this.dispatcher;
    }

    @Override
    @NotNull
    public ServerProcess.Ticker ticker() {
        return this.ticker;
    }

    @Override
    public void start(@NotNull SocketAddress socketAddress) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Server already started");
        }
        LOGGER.info("Starting " + MinecraftServer.getBrandName() + " server.");
        try {
            this.server.init(socketAddress);
        }
        catch (IOException e) {
            this.exception.handleException(e);
            throw new RuntimeException(e);
        }
        this.server.start();
        LOGGER.info(MinecraftServer.getBrandName() + " server started successfully.");
        if (SHUTDOWN_ON_SIGNAL.booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        }
    }

    @Override
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        LOGGER.info("Stopping " + MinecraftServer.getBrandName() + " server.");
        this.scheduler.shutdown();
        this.connection.shutdown();
        this.server.stop();
        LOGGER.info("Shutting down all thread pools.");
        this.benchmark.disable();
        this.dispatcher.shutdown();
        LOGGER.info(MinecraftServer.getBrandName() + " server stopped successfully.");
    }

    @Override
    public boolean isAlive() {
        return this.started.get() && !this.stopped.get();
    }

    @Override
    @NotNull
    public ServerSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        ArrayList instanceRefs = new ArrayList();
        Int2ObjectOpenHashMap entityRefs = new Int2ObjectOpenHashMap();
        for (Instance instance : this.instance.getInstances()) {
            instanceRefs.add(updater.reference(instance));
            for (Entity entity : instance.getEntities()) {
                entityRefs.put(entity.getEntityId(), updater.reference(entity));
            }
        }
        return new SnapshotImpl.Server(MappedCollection.plainReferences(instanceRefs), (Int2ObjectOpenHashMap<AtomicReference<EntitySnapshot>>)entityRefs);
    }

    private final class TickerImpl
    implements ServerProcess.Ticker {
        private TickerImpl() {
        }

        @Override
        public void tick(long nanoTime) {
            long msTime = System.currentTimeMillis();
            ServerProcessImpl.this.scheduler().processTick();
            ServerProcessImpl.this.connection().tick(msTime);
            this.serverTick(msTime);
            ServerProcessImpl.this.scheduler().processTickEnd();
            PacketUtils.flush();
            ServerProcessImpl.this.server().tick();
            double acquisitionTimeMs = (double)Acquirable.resetAcquiringTime() / 1000000.0;
            double tickTimeMs = (double)(System.nanoTime() - nanoTime) / 1000000.0;
            TickMonitor tickMonitor = new TickMonitor(tickTimeMs, acquisitionTimeMs);
            EventDispatcher.call(new ServerTickMonitorEvent(tickMonitor));
        }

        private void serverTick(long tickStart) {
            for (Instance instance : ServerProcessImpl.this.instance().getInstances()) {
                try {
                    instance.tick(tickStart);
                }
                catch (Exception e) {
                    ServerProcessImpl.this.exception().handleException(e);
                }
            }
            ServerProcessImpl.this.dispatcher().updateAndAwait(tickStart);
            long tickTime = System.currentTimeMillis() - tickStart;
            ServerProcessImpl.this.dispatcher().refreshThreads(tickTime);
        }
    }
}

