/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import net.minestom.server.MinecraftServer;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.CommandDispatcher;
import net.minestom.server.command.builder.CommandResult;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ArgumentCommand
extends Argument<CommandResult> {
    public static final int INVALID_COMMAND_ERROR = 1;
    private boolean onlyCorrect;
    private String shortcut = "";

    public ArgumentCommand(@NotNull String id) {
        super(id, true, true);
    }

    @Override
    @NotNull
    public CommandResult parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        String commandString = !this.shortcut.isEmpty() ? this.shortcut + " " + input : input;
        CommandDispatcher dispatcher = MinecraftServer.getCommandManager().getDispatcher();
        CommandResult result = dispatcher.parse(sender, commandString);
        if (this.onlyCorrect && result.getType() != CommandResult.Type.SUCCESS) {
            throw new ArgumentSyntaxException("Invalid command", input, 1);
        }
        return result;
    }

    @Override
    public String parser() {
        return null;
    }

    public boolean isOnlyCorrect() {
        return this.onlyCorrect;
    }

    public ArgumentCommand setOnlyCorrect(boolean onlyCorrect) {
        this.onlyCorrect = onlyCorrect;
        return this;
    }

    @NotNull
    public String getShortcut() {
        return this.shortcut;
    }

    @ApiStatus.Experimental
    public ArgumentCommand setShortcut(@NotNull String shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public String toString() {
        return String.format("Command<%s>", this.getId());
    }
}

