/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.io.IOException;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.CustomData;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;

public class ArgumentItemStack
extends Argument<ItemStack> {
    public static final int NO_MATERIAL = 1;
    public static final int INVALID_NBT = 2;
    public static final int INVALID_MATERIAL = 3;
    public static final int INVALID_COMPONENT = 4;

    public ArgumentItemStack(String id) {
        super(id, true);
    }

    @Override
    @NotNull
    public ItemStack parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        return ArgumentItemStack.staticParse(input);
    }

    @Override
    public String parser() {
        return "minecraft:item_stack";
    }

    @Deprecated
    public static ItemStack staticParse(@NotNull String input) throws ArgumentSyntaxException {
        StringReader reader = new StringReader(input);
        Material material = Material.fromNamespaceId(reader.readNamespaceId());
        if (material == null) {
            throw new ArgumentSyntaxException("Material is invalid", input, 3);
        }
        if (!reader.hasMore()) {
            return ItemStack.of(material);
        }
        DataComponentMap.Builder components = DataComponentMap.builder();
        if (reader.peek() == '[') {
            reader.consume('[');
            do {
                NamespaceID componentId;
                DataComponent<?> component;
                if ((component = DataComponent.fromNamespaceId(componentId = reader.readNamespaceId())) == null) {
                    throw new ArgumentSyntaxException("Unknown item component", input, 4);
                }
                reader.consume('=');
                BinaryTag nbt = reader.readTag();
                components.set(component, component.read(nbt));
                if (reader.peek() == ']') continue;
                reader.consume(',');
            } while (reader.peek() != ']');
            reader.consume(']');
        }
        if (reader.hasMore() && reader.peek() == '{') {
            BinaryTag nbt = reader.readTag();
            if (!(nbt instanceof CompoundBinaryTag)) {
                throw new ArgumentSyntaxException("Item NBT must be compound", input, 2);
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)nbt;
            CompoundBinaryTag customData = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(components.get(ItemComponent.CUSTOM_DATA, CustomData.EMPTY).nbt())).put(compound)).build();
            components.set(ItemComponent.CUSTOM_DATA, new CustomData(customData));
        }
        if (reader.hasMore()) {
            throw new ArgumentSyntaxException("Unexpected remaining input", input, 2);
        }
        return ItemStack.of(material, components.build());
    }

    public String toString() {
        return String.format("ItemStack<%s>", this.getId());
    }

    private static class StringReader {
        private String input;
        private int index = 0;

        public StringReader(@NotNull String input) {
            this.input = input;
        }

        public boolean hasMore() {
            return this.index < this.input.length();
        }

        public char peek() {
            if (!this.hasMore()) {
                throw new ArgumentSyntaxException("Unexpected end of input", this.input, 2);
            }
            return this.input.charAt(this.index);
        }

        public void consume(char c) {
            char next = this.peek();
            if (next != c) {
                throw new ArgumentSyntaxException("Expected '" + c + "', got '" + next + "'", this.input, 2);
            }
            ++this.index;
        }

        @NotNull
        public NamespaceID readNamespaceId() {
            char c;
            int start = this.index;
            while (this.hasMore() && (c = this.peek()) != '{' && c != '[' && c != '=') {
                ++this.index;
            }
            return NamespaceID.from(this.input.substring(start, this.index));
        }

        @NotNull
        public BinaryTag readTag() {
            try {
                Map.Entry<BinaryTag, String> result = TagStringIOExt.readTagEmbedded(this.input.substring(this.index));
                this.input = result.getValue();
                this.index = 0;
                return result.getKey();
            }
            catch (IOException e) {
                throw new ArgumentSyntaxException("Invalid NBT", this.input, 2);
            }
        }
    }
}

