/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import java.util.Collection;
import net.kyori.adventure.nbt.BinaryTag;
import net.minestom.server.component.DataComponentImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DataComponent<T>
extends StaticProtocolObject
permits DataComponentImpl {
    public boolean isSynced();

    public boolean isSerialized();

    @NotNull
    public T read(@NotNull BinaryTag var1);

    @NotNull
    public BinaryTag write(@NotNull T var1);

    @NotNull
    public T read(@NotNull NetworkBuffer var1);

    public void write(@NotNull NetworkBuffer var1, @NotNull T var2);

    @Nullable
    public static DataComponent<?> fromNamespaceId(@NotNull String namespaceId) {
        return DataComponentImpl.NAMESPACES.get(namespaceId);
    }

    @Nullable
    public static DataComponent<?> fromNamespaceId(@NotNull NamespaceID namespaceId) {
        return DataComponent.fromNamespaceId(namespaceId.asString());
    }

    @Nullable
    public static DataComponent<?> fromId(int id) {
        return DataComponentImpl.IDS.get(id);
    }

    @NotNull
    public static Collection<DataComponent<?>> values() {
        return DataComponentImpl.NAMESPACES.values();
    }

    @ApiStatus.Internal
    public static <T> DataComponent<T> register(@NotNull String name, @Nullable NetworkBuffer.Type<T> network, @Nullable BinaryTagSerializer<T> nbt) {
        DataComponentImpl<T> impl = new DataComponentImpl<T>(DataComponentImpl.NAMESPACES.size(), NamespaceID.from(name), network, nbt);
        DataComponentImpl.NAMESPACES.put(impl.name(), impl);
        DataComponentImpl.IDS.set(impl.id(), impl);
        return impl;
    }
}

