/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.minestom.server.component.DataComponent;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.collection.ObjectArray;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record DataComponentImpl<T>(int id, @NotNull NamespaceID namespace, @Nullable NetworkBuffer.Type<T> network, @Nullable BinaryTagSerializer<T> nbt) implements DataComponent<T>
{
    static final Map<String, DataComponent<?>> NAMESPACES = new HashMap(32);
    static final ObjectArray<DataComponent<?>> IDS = ObjectArray.singleThread(32);

    @Override
    public boolean isSynced() {
        return this.network != null;
    }

    @Override
    public boolean isSerialized() {
        return this.nbt != null;
    }

    @Override
    @NotNull
    public T read(@NotNull BinaryTag tag) {
        Check.notNull(this.nbt, "{0} cannot be deserialized from NBT", this);
        return this.nbt.read(tag);
    }

    @Override
    @NotNull
    public BinaryTag write(@NotNull T value) {
        Check.notNull(this.nbt, "{0} cannot be serialized to NBT", this);
        return this.nbt.write(value);
    }

    @Override
    @NotNull
    public T read(@NotNull NetworkBuffer reader) {
        Check.notNull(this.network, "{0} cannot be deserialized from network", this);
        return this.network.read(reader);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer, @NotNull T value) {
        Check.notNull(this.network, "{0} cannot be serialized to network", this);
        this.network.write(writer, value);
    }

    @Override
    public String toString() {
        return this.name();
    }

    static {
        try {
            Class.forName(ItemComponent.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

