/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponentMapImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DataComponentPatch(@NotNull Int2ObjectMap<Object> patch) {
    private static final char REMOVAL_PREFIX = '!';
    public static final DataComponentPatch EMPTY = new DataComponentPatch((Int2ObjectMap<Object>)new Int2ObjectArrayMap(0));
    @NotNull
    public static final NetworkBuffer.Type<DataComponentPatch> NETWORK_TYPE = new NetworkBuffer.Type<DataComponentPatch>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, DataComponentPatch value) {
            int added = 0;
            for (Object o : value.patch.values()) {
                if (o == null) continue;
                ++added;
            }
            buffer.write(NetworkBuffer.VAR_INT, added);
            buffer.write(NetworkBuffer.VAR_INT, value.patch.size() - added);
            for (Int2ObjectMap.Entry entry : value.patch.int2ObjectEntrySet()) {
                if (entry.getValue() == null) continue;
                buffer.write(NetworkBuffer.VAR_INT, entry.getIntKey());
                DataComponent<?> type = DataComponent.fromId(entry.getIntKey());
                assert (type != null);
                type.write(buffer, entry.getValue());
            }
            for (Int2ObjectMap.Entry entry : value.patch.int2ObjectEntrySet()) {
                if (entry.getValue() != null) continue;
                buffer.write(NetworkBuffer.VAR_INT, entry.getIntKey());
            }
        }

        @Override
        public DataComponentPatch read(@NotNull NetworkBuffer buffer) {
            int id;
            int i;
            int removed;
            int added = buffer.read(NetworkBuffer.VAR_INT);
            Check.stateCondition(added + (removed = buffer.read(NetworkBuffer.VAR_INT).intValue()) > DataComponent.values().size() * 2, "Item component patch too large: {0}", added + removed);
            Int2ObjectArrayMap patch = new Int2ObjectArrayMap(added + removed);
            for (i = 0; i < added; ++i) {
                id = buffer.read(NetworkBuffer.VAR_INT);
                DataComponent<?> type = DataComponent.fromId(id);
                Check.notNull(type, "Unknown item component id: {0}", id);
                patch.put(id, type.read(buffer));
            }
            for (i = 0; i < removed; ++i) {
                id = buffer.read(NetworkBuffer.VAR_INT);
                patch.put(id, null);
            }
            return new DataComponentPatch((Int2ObjectMap<Object>)patch);
        }
    };
    @NotNull
    public static final BinaryTagSerializer<DataComponentPatch> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        if (tag.size() == 0) {
            return EMPTY;
        }
        Int2ObjectArrayMap patch = new Int2ObjectArrayMap(tag.size());
        for (Map.Entry entry : tag) {
            String key = (String)entry.getKey();
            boolean remove = false;
            if (!key.isEmpty() && key.charAt(0) == '!') {
                key = key.substring(1);
                remove = true;
            }
            DataComponent<?> type = DataComponent.fromNamespaceId(key);
            Check.notNull(type, "Unknown item component: {0}", key);
            if (remove) {
                patch.put(type.id(), null);
                continue;
            }
            Object value = type.read((BinaryTag)entry.getValue());
            patch.put(type.id(), value);
        }
        return new DataComponentPatch((Int2ObjectMap<Object>)patch);
    }, patch -> {
        if (patch.patch.isEmpty()) {
            return CompoundBinaryTag.empty();
        }
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        for (Int2ObjectMap.Entry entry : patch.patch.int2ObjectEntrySet()) {
            DataComponent<?> type = DataComponent.fromId(entry.getIntKey());
            Check.notNull(type, "Unknown item component id: {0}", entry.getIntKey());
            if (entry.getValue() == null) {
                builder.put("!" + type.name(), (BinaryTag)CompoundBinaryTag.empty());
                continue;
            }
            builder.put(type.name(), type.write(entry.getValue()));
        }
        return builder.build();
    });

    @NotNull
    public static DataComponentPatch from(@NotNull DataComponentMap prototype, @NotNull DataComponentMap components) {
        return new DataComponentPatch(((DataComponentMapImpl)components).components());
    }

    public boolean has(@NotNull DataComponentMap prototype, @NotNull DataComponent<?> component) {
        if (this.patch.containsKey(component.id())) {
            return this.patch.get(component.id()) != null;
        }
        return prototype.has(component);
    }

    @Nullable
    public <T> T get(@NotNull DataComponentMap prototype, @NotNull DataComponent<T> component) {
        if (this.patch.containsKey(component.id())) {
            return (T)this.patch.get(component.id());
        }
        return prototype.get(component);
    }

    @NotNull
    public <T> DataComponentPatch with(@NotNull DataComponent<T> component, @NotNull T value) {
        Int2ObjectArrayMap newPatch = new Int2ObjectArrayMap(this.patch);
        newPatch.put(component.id(), value);
        return new DataComponentPatch((Int2ObjectMap<Object>)newPatch);
    }

    @NotNull
    public <T> DataComponentPatch without(@NotNull DataComponent<T> component) {
        Int2ObjectArrayMap newPatch = new Int2ObjectArrayMap(this.patch);
        newPatch.put(component.id(), null);
        return new DataComponentPatch((Int2ObjectMap<Object>)newPatch);
    }

    @NotNull
    public Builder builder() {
        return new Builder((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.patch));
    }

    public record Builder(@NotNull Int2ObjectMap<Object> patch) implements DataComponentMap
    {
        @Override
        public boolean has(@NotNull DataComponent<?> component) {
            return this.patch.get(component.id()) != null;
        }

        @Override
        @Nullable
        public <T> T get(@NotNull DataComponent<T> component) {
            return (T)this.patch.get(component.id());
        }

        public <T> @NotNull Builder set(@NotNull DataComponent<T> component, @NotNull T value) {
            this.patch.put(component.id(), value);
            return this;
        }

        public @NotNull Builder remove(@NotNull DataComponent<?> component) {
            this.patch.put(component.id(), null);
            return this;
        }

        @NotNull
        public DataComponentPatch build() {
            return new DataComponentPatch((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.patch));
        }
    }
}

