/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.ServerFlag;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.Instance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EntityView {
    private static final int RANGE = ServerFlag.ENTITY_VIEW_DISTANCE;
    private final Entity entity;
    private final Set<Player> manualViewers = new HashSet<Player>();
    public final Option<Player> viewableOption;
    public final Option<Entity> viewerOption;
    final Set<Player> set = new SetImpl();
    private final Object mutex = this;
    private volatile TrackedLocation trackedLocation;

    public EntityView(Entity entity) {
        Consumer<Entity> consumer;
        Consumer<Entity> consumer2;
        Player player2;
        this.entity = entity;
        this.viewableOption = new Option<Player>(EntityTracker.Target.PLAYERS, Entity::autoViewEntities, player -> {
            Entity lock1 = player.getEntityId() < entity.getEntityId() ? player : entity;
            Entity lock2 = lock1 == entity ? player : entity;
            Object object = lock1.viewEngine.mutex;
            synchronized (object) {
                Object object2 = lock2.viewEngine.mutex;
                synchronized (object2) {
                    if (!entity.viewEngine.viewableOption.predicate((Player)player) || !player.viewEngine.viewerOption.predicate(entity)) {
                        return;
                    }
                    entity.viewEngine.viewableOption.register((Player)player);
                    player.viewEngine.viewerOption.register(entity);
                }
            }
            if (entity.getVehicle() != null) {
                return;
            }
            entity.updateNewViewer((Player)player);
        }, player -> {
            Entity lock1 = player.getEntityId() < entity.getEntityId() ? player : entity;
            Entity lock2 = lock1 == entity ? player : entity;
            Object object = lock1.viewEngine.mutex;
            synchronized (object) {
                Object object2 = lock2.viewEngine.mutex;
                synchronized (object2) {
                    entity.viewEngine.viewableOption.unregister((Player)player);
                    player.viewEngine.viewerOption.unregister(entity);
                }
            }
            entity.updateOldViewer((Player)player);
        });
        Predicate<Entity> predicate = Entity::isAutoViewable;
        if (entity instanceof Player) {
            player2 = (Player)entity;
            consumer2 = e -> e.viewEngine.viewableOption.addition.accept(player2);
        } else {
            consumer2 = null;
        }
        if (entity instanceof Player) {
            player2 = (Player)entity;
            consumer = e -> e.viewEngine.viewableOption.removal.accept(player2);
        } else {
            consumer = null;
        }
        this.viewerOption = new Option<Entity>(EntityTracker.Target.ENTITIES, predicate, consumer2, consumer);
    }

    public void updateTracker(@Nullable Instance instance, @NotNull Point point) {
        this.trackedLocation = instance != null ? new TrackedLocation(instance, point) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean manualAdd(@NotNull Player player) {
        if (player == this.entity) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.manualViewers.add(player)) {
                this.viewableOption.bitSet.add(player.getEntityId());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean manualRemove(@NotNull Player player) {
        if (player == this.entity) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.manualViewers.remove(player)) {
                this.viewableOption.bitSet.remove(player.getEntityId());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forManuals(@NotNull Consumer<Player> consumer) {
        Object object = this.mutex;
        synchronized (object) {
            Set<Player> manualViewersCopy = Set.copyOf(this.manualViewers);
            manualViewersCopy.forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPredictableViewers() {
        Object object = this.mutex;
        synchronized (object) {
            return this.viewableOption.isAuto() && this.viewableOption.predicate == null && this.manualViewers.isEmpty();
        }
    }

    public void handleAutoViewAddition(Entity entity) {
        this.handleAutoView(entity, this.viewerOption.addition, this.viewableOption.addition);
    }

    public void handleAutoViewRemoval(Entity entity) {
        this.handleAutoView(entity, this.viewerOption.removal, this.viewableOption.removal);
    }

    private void handleAutoView(Entity entity, Consumer<Entity> viewer, Consumer<Player> viewable) {
        Player player;
        if (this.entity instanceof Player && this.viewerOption.isAuto() && entity.isAutoViewable() && viewer != null) {
            viewer.accept(entity);
        }
        if (entity instanceof Player && (player = (Player)entity).autoViewEntities() && this.viewableOption.isAuto() && viewable != null) {
            viewable.accept(player);
        }
    }

    final class SetImpl
    extends AbstractSet<Player> {
        SetImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Iterator<Player> iterator() {
            ArrayList<Player> players;
            Object object = EntityView.this.mutex;
            synchronized (object) {
                IntSet bitSet = EntityView.this.viewableOption.bitSet;
                if (bitSet.isEmpty()) {
                    return Collections.emptyIterator();
                }
                players = new ArrayList<Player>(bitSet.size());
                IntIterator it = bitSet.intIterator();
                while (it.hasNext()) {
                    int id = it.nextInt();
                    Player player = (Player)Entity.getEntity(id);
                    if (player == null) continue;
                    players.add(player);
                }
            }
            return players.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = EntityView.this.mutex;
            synchronized (object) {
                return EntityView.this.viewableOption.bitSet.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = EntityView.this.mutex;
            synchronized (object) {
                return EntityView.this.viewableOption.bitSet.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Player)) {
                return false;
            }
            Player player = (Player)o;
            Object object = EntityView.this.mutex;
            synchronized (object) {
                return EntityView.this.viewableOption.isRegistered(player);
            }
        }
    }

    public final class Option<T extends Entity> {
        private static final AtomicIntegerFieldUpdater<Option> UPDATER = AtomicIntegerFieldUpdater.newUpdater(Option.class, "auto");
        private final EntityTracker.Target<T> target;
        private final Predicate<T> loopPredicate;
        public final Consumer<T> addition;
        public final Consumer<T> removal;
        public final IntSet bitSet = new IntOpenHashSet();
        private volatile int auto = 1;
        private Predicate<T> predicate = null;
        private int lastSize;

        public Option(EntityTracker.Target<T> target, Predicate<T> loopPredicate, Consumer<T> addition, Consumer<T> removal) {
            this.target = target;
            this.loopPredicate = loopPredicate;
            this.addition = addition;
            this.removal = removal;
        }

        public boolean isAuto() {
            return this.auto == 1;
        }

        public boolean predicate(T entity) {
            Predicate<T> predicate = this.predicate;
            return predicate == null || predicate.test(entity);
        }

        public boolean isRegistered(T entity) {
            return this.bitSet.contains(((Entity)entity).getEntityId());
        }

        public void register(T entity) {
            assert (Entity.getEntity(((Entity)entity).getEntityId()) == entity) : "Unregistered entity shouldn't be registered as viewer";
            this.bitSet.add(((Entity)entity).getEntityId());
        }

        public void unregister(T entity) {
            this.bitSet.remove(((Entity)entity).getEntityId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAuto(boolean autoViewable) {
            boolean previous;
            boolean bl = previous = UPDATER.getAndSet(this, autoViewable ? 1 : 0) == 1;
            if (previous != autoViewable) {
                Object object = EntityView.this.mutex;
                synchronized (object) {
                    if (autoViewable) {
                        this.update(this.loopPredicate, this.addition);
                    } else {
                        this.update(this::isRegistered, this.removal);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateRule(Predicate<T> predicate) {
            Object object = EntityView.this.mutex;
            synchronized (object) {
                this.predicate = predicate;
                this.updateRule0(predicate);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateRule() {
            Object object = EntityView.this.mutex;
            synchronized (object) {
                this.updateRule0(this.predicate);
            }
        }

        void updateRule0(Predicate<T> predicate) {
            if (predicate == null) {
                this.update(this.loopPredicate, entity -> {
                    if (!this.isRegistered(entity)) {
                        this.addition.accept((Entity)entity);
                    }
                });
            } else {
                this.update(this.loopPredicate, entity -> {
                    boolean result = predicate.test(entity);
                    if (result != this.isRegistered(entity)) {
                        if (result) {
                            this.addition.accept((Entity)entity);
                        } else {
                            this.removal.accept((Entity)entity);
                        }
                    }
                });
            }
        }

        private void update(Predicate<T> visibilityPredicate, Consumer<T> action) {
            this.references().forEach(entity -> {
                Player player;
                if (entity == EntityView.this.entity || !visibilityPredicate.test(entity)) {
                    return;
                }
                if (entity instanceof Player && EntityView.this.manualViewers.contains(player = (Player)entity)) {
                    return;
                }
                if (entity.getVehicle() != null) {
                    return;
                }
                action.accept(entity);
            });
        }

        private Collection<T> references() {
            TrackedLocation trackedLocation = EntityView.this.trackedLocation;
            if (trackedLocation == null) {
                return List.of();
            }
            Instance instance = trackedLocation.instance();
            Point point = trackedLocation.point();
            Int2ObjectOpenHashMap entityMap = new Int2ObjectOpenHashMap(this.lastSize);
            instance.getEntityTracker().nearbyEntitiesByChunkRange(point, RANGE, this.target, entity -> entityMap.putIfAbsent(entity.getEntityId(), entity));
            this.lastSize = entityMap.size();
            return entityMap.values();
        }
    }

    record TrackedLocation(Instance instance, Point point) {
    }
}

