/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.animal.ArmadilloMeta;
import net.minestom.server.entity.metadata.animal.FrogMeta;
import net.minestom.server.entity.metadata.animal.SnifferMeta;
import net.minestom.server.entity.metadata.animal.tameable.CatMeta;
import net.minestom.server.entity.metadata.other.PaintingMeta;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.particle.Particle;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

final class MetadataImpl {
    static final ObjectArray<Metadata.Entry<?>> EMPTY_VALUES = ObjectArray.singleThread(20);

    MetadataImpl() {
    }

    static {
        EMPTY_VALUES.set(Metadata.TYPE_BYTE, Metadata.Byte((byte)0));
        EMPTY_VALUES.set(Metadata.TYPE_VARINT, Metadata.VarInt(0));
        EMPTY_VALUES.set(Metadata.TYPE_LONG, Metadata.Long(0L));
        EMPTY_VALUES.set(Metadata.TYPE_FLOAT, Metadata.Float(0.0f));
        EMPTY_VALUES.set(Metadata.TYPE_STRING, Metadata.String(""));
        EMPTY_VALUES.set(Metadata.TYPE_CHAT, Metadata.Chat((Component)Component.empty()));
        EMPTY_VALUES.set(Metadata.TYPE_OPT_CHAT, Metadata.OptChat(null));
        EMPTY_VALUES.set(Metadata.TYPE_ITEM_STACK, Metadata.ItemStack(ItemStack.AIR));
        EMPTY_VALUES.set(Metadata.TYPE_BOOLEAN, Metadata.Boolean(false));
        EMPTY_VALUES.set(Metadata.TYPE_ROTATION, Metadata.Rotation(Vec.ZERO));
        EMPTY_VALUES.set(Metadata.TYPE_BLOCK_POSITION, Metadata.BlockPosition(Vec.ZERO));
        EMPTY_VALUES.set(Metadata.TYPE_OPT_BLOCK_POSITION, Metadata.OptBlockPosition(null));
        EMPTY_VALUES.set(Metadata.TYPE_DIRECTION, Metadata.Direction(Direction.DOWN));
        EMPTY_VALUES.set(Metadata.TYPE_OPT_UUID, Metadata.OptUUID(null));
        EMPTY_VALUES.set(Metadata.TYPE_BLOCKSTATE, Metadata.BlockState(Block.AIR.id()));
        EMPTY_VALUES.set(Metadata.TYPE_OPT_BLOCKSTATE, Metadata.OptBlockState(null));
        EMPTY_VALUES.set(Metadata.TYPE_NBT, Metadata.NBT((BinaryTag)EndBinaryTag.endBinaryTag()));
        EMPTY_VALUES.set(Metadata.TYPE_PARTICLE, Metadata.Particle(Particle.DUST));
        EMPTY_VALUES.set(Metadata.TYPE_PARTICLE_LIST, Metadata.ParticleList(List.of()));
        EMPTY_VALUES.set(Metadata.TYPE_VILLAGERDATA, Metadata.VillagerData(0, 0, 0));
        EMPTY_VALUES.set(Metadata.TYPE_OPT_VARINT, Metadata.OptVarInt(null));
        EMPTY_VALUES.set(Metadata.TYPE_POSE, Metadata.Pose(Entity.Pose.STANDING));
        EMPTY_VALUES.set(Metadata.TYPE_CAT_VARIANT, Metadata.CatVariant(CatMeta.Variant.TABBY));
        EMPTY_VALUES.set(Metadata.TYPE_FROG_VARIANT, Metadata.FrogVariant(FrogMeta.Variant.TEMPERATE));
        EMPTY_VALUES.set(Metadata.TYPE_PAINTING_VARIANT, Metadata.PaintingVariant(PaintingMeta.Variant.KEBAB));
        EMPTY_VALUES.set(Metadata.TYPE_SNIFFER_STATE, Metadata.SnifferState(SnifferMeta.State.IDLING));
        EMPTY_VALUES.set(Metadata.TYPE_ARMADILLO_STATE, Metadata.ArmadilloState(ArmadilloMeta.State.IDLE));
        EMPTY_VALUES.set(Metadata.TYPE_VECTOR3, Metadata.Vector3(Vec.ZERO));
        EMPTY_VALUES.set(Metadata.TYPE_QUATERNION, Metadata.Quaternion(new float[]{0.0f, 0.0f, 0.0f, 0.0f}));
        EMPTY_VALUES.trim();
    }

    record EntryImpl<T>(int type, @UnknownNullability T value, @NotNull NetworkBuffer.Type<T> serializer) implements Metadata.Entry<T>
    {
        static Metadata.Entry<?> read(int type, @NotNull NetworkBuffer reader) {
            EntryImpl value = (EntryImpl)EMPTY_VALUES.get(type);
            if (value == null) {
                throw new UnsupportedOperationException("Unknown value type: " + type);
            }
            return value.withValue(reader);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.type);
            writer.write(this.serializer, this.value);
        }

        private EntryImpl<T> withValue(@NotNull NetworkBuffer reader) {
            return new EntryImpl<T>(this.type, reader.read(this.serializer), this.serializer);
        }
    }
}

