/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.attribute;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.entity.attribute.AttributeOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeInstance {
    private final Attribute attribute;
    private final Map<UUID, AttributeModifier> modifiers = new HashMap<UUID, AttributeModifier>();
    private final Consumer<AttributeInstance> propertyChangeListener;
    private double baseValue;
    private double cachedValue = 0.0;

    public AttributeInstance(@NotNull Attribute attribute, @Nullable Consumer<AttributeInstance> listener) {
        this.attribute = attribute;
        this.propertyChangeListener = listener;
        this.baseValue = attribute.defaultValue();
        this.refreshCachedValue();
    }

    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double baseValue) {
        if (this.baseValue != baseValue) {
            this.baseValue = baseValue;
            this.refreshCachedValue();
        }
    }

    public void addModifier(@NotNull AttributeModifier modifier) {
        if (this.modifiers.putIfAbsent(modifier.getId(), modifier) == null) {
            this.refreshCachedValue();
        }
    }

    public void removeModifier(@NotNull AttributeModifier modifier) {
        this.removeModifier(modifier.getId());
    }

    public void removeModifier(@NotNull UUID uuid) {
        if (this.modifiers.remove(uuid) != null) {
            this.refreshCachedValue();
        }
    }

    @NotNull
    public Collection<AttributeModifier> getModifiers() {
        return this.modifiers.values();
    }

    public double getValue() {
        return this.cachedValue;
    }

    private void refreshCachedValue() {
        Collection<AttributeModifier> modifiers = this.getModifiers();
        double base = this.getBaseValue();
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.getOperation() == AttributeOperation.ADD_VALUE).toArray(AttributeModifier[]::new)) {
            base += modifier.getAmount();
        }
        double result = base;
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.getOperation() == AttributeOperation.MULTIPLY_BASE).toArray(AttributeModifier[]::new)) {
            result += base * modifier.getAmount();
        }
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.getOperation() == AttributeOperation.MULTIPLY_TOTAL).toArray(AttributeModifier[]::new)) {
            result *= 1.0 + modifier.getAmount();
        }
        this.cachedValue = Math.clamp(result, this.getAttribute().minValue(), this.getAttribute().maxValue());
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.accept(this);
        }
    }
}

