/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.entity;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import net.minestom.server.entity.Entity;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.event.trait.EntityInstanceEvent;
import org.jetbrains.annotations.NotNull;

public class EntityFireEvent
implements EntityInstanceEvent,
CancellableEvent {
    private final Entity entity;
    private Duration duration;
    private boolean cancelled;

    public EntityFireEvent(Entity entity, int duration, TemporalUnit temporalUnit) {
        this(entity, Duration.of(duration, temporalUnit));
    }

    public EntityFireEvent(Entity entity, Duration duration) {
        this.entity = entity;
        this.setFireTime(duration);
    }

    public long getFireTime(TemporalUnit temporalUnit) {
        return this.duration.toNanos() / temporalUnit.getDuration().toNanos();
    }

    public void setFireTime(int duration, TemporalUnit temporalUnit) {
        this.setFireTime(Duration.of(duration, temporalUnit));
    }

    public void setFireTime(Duration duration) {
        this.duration = duration;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public Entity getEntity() {
        return this.entity;
    }
}

