/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.PlayerEvent;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.network.plugin.LoginPluginResponse;
import org.jetbrains.annotations.NotNull;

public class AsyncPlayerPreLoginEvent
implements PlayerEvent {
    private final Player player;
    private final LoginPluginMessageProcessor pluginMessageProcessor;
    private String username;
    private UUID playerUuid;

    public AsyncPlayerPreLoginEvent(@NotNull Player player, @NotNull LoginPluginMessageProcessor pluginMessageProcessor) {
        this.player = player;
        this.pluginMessageProcessor = pluginMessageProcessor;
        this.username = player.getUsername();
        this.playerUuid = player.getUuid();
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@NotNull String username) {
        this.username = username;
    }

    @NotNull
    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public void setPlayerUuid(@NotNull UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    @NotNull
    public CompletableFuture<LoginPluginResponse> sendPluginRequest(String channel, byte[] requestPayload) {
        return this.pluginMessageProcessor.request(channel, requestPayload);
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }
}

