/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.generator.GenerationUnit;
import net.minestom.server.instance.generator.UnitModifier;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.world.biomes.Biome;
import net.minestom.server.world.biomes.BiomeManager;
import org.jetbrains.annotations.NotNull;

final class GeneratorImpl {
    private static final Vec SECTION_SIZE = new Vec(16.0);
    private static final BiomeManager BIOME_MANAGER = MinecraftServer.getBiomeManager();

    GeneratorImpl() {
    }

    static GenerationUnit section(Section section, int sectionX, int sectionY, int sectionZ, boolean fork) {
        Vec start = SECTION_SIZE.mul(sectionX, sectionY, sectionZ);
        Vec end = start.add(SECTION_SIZE);
        SectionModifierImpl modifier = new SectionModifierImpl(SECTION_SIZE, start, end, section.blockPalette(), section.biomePalette(), (Int2ObjectMap<Block>)new Int2ObjectOpenHashMap(0), fork);
        return GeneratorImpl.unit(modifier, start, end, null);
    }

    static GenerationUnit section(Section section, int sectionX, int sectionY, int sectionZ) {
        return GeneratorImpl.section(section, sectionX, sectionY, sectionZ, false);
    }

    static UnitImpl chunk(Chunk chunk, int minSection, int maxSection, List<Section> chunkSections, int chunkX, int chunkZ) {
        int minY = minSection * 16;
        AtomicInteger sectionCounterY = new AtomicInteger(minSection);
        List<GenerationUnit> sections = chunkSections.stream().map(section -> GeneratorImpl.section(section, chunkX, sectionCounterY.getAndIncrement(), chunkZ)).toList();
        Vec size = new Vec(16.0, (maxSection - minSection) * 16, 16.0);
        Vec start = new Vec(chunkX * 16, minY, chunkZ * 16);
        Vec end = new Vec(chunkX * 16 + 16, size.y() + (double)minY, chunkZ * 16 + 16);
        AreaModifierImpl modifier = new AreaModifierImpl(chunk, size, start, end, 1, sections.size(), 1, sections);
        return GeneratorImpl.unit(modifier, start, end, sections);
    }

    static UnitImpl chunk(int minSection, int maxSection, List<Section> chunkSections, int chunkX, int chunkZ) {
        return GeneratorImpl.chunk(null, minSection, maxSection, chunkSections, chunkX, chunkZ);
    }

    static UnitImpl chunk(Chunk chunk) {
        return GeneratorImpl.chunk(chunk, chunk.minSection, chunk.maxSection, chunk.getSections(), chunk.getChunkX(), chunk.getChunkZ());
    }

    static UnitImpl unit(UnitModifier modifier, Point start, Point end, List<GenerationUnit> divided) {
        if (start.x() > end.x() || start.y() > end.y() || start.z() > end.z()) {
            throw new IllegalArgumentException("absoluteStart must be before absoluteEnd");
        }
        if (start.x() % 16.0 != 0.0 || start.y() % 16.0 != 0.0 || start.z() % 16.0 != 0.0) {
            throw new IllegalArgumentException("absoluteStart must be a multiple of 16");
        }
        if (end.x() % 16.0 != 0.0 || end.y() % 16.0 != 0.0 || end.z() % 16.0 != 0.0) {
            throw new IllegalArgumentException("absoluteEnd must be a multiple of 16");
        }
        Point size = end.sub(start);
        return new UnitImpl(modifier, size, start, end, divided, new CopyOnWriteArrayList<UnitImpl>());
    }

    private static GenerationUnit findAbsolute(List<GenerationUnit> units, Point start, int width, int height, int depth, int x, int y, int z) {
        int sectionX = ChunkUtils.getChunkCoordinate((double)x - start.x());
        int sectionY = ChunkUtils.getChunkCoordinate((double)y - start.y());
        int sectionZ = ChunkUtils.getChunkCoordinate((double)z - start.z());
        int index = GeneratorImpl.findIndex(width, height, depth, sectionX, sectionY, sectionZ);
        return units.get(index);
    }

    private static int findIndex(int width, int height, int depth, int x, int y, int z) {
        return z * width * height + y * width + x;
    }

    private static Point to3D(int idx, int width, int height, int depth) {
        int z = idx / (width * height);
        int y = (idx -= z * width * height) / width;
        int x = idx % width;
        return new Vec(x, y, z);
    }

    record SectionModifierImpl(Point size, Point start, Point end, Palette blockPalette, Palette biomePalette, Int2ObjectMap<Block> cache, boolean fork) implements GenericModifier
    {
        @Override
        public void setBiome(int x, int y, int z, @NotNull Biome biome) {
            if (this.fork) {
                throw new IllegalStateException("Cannot modify biomes of a fork");
            }
            int id = BIOME_MANAGER.getId(biome);
            if (id == -1) {
                throw new IllegalStateException("Biome has not been registered: " + String.valueOf(biome.namespace()));
            }
            this.biomePalette.set(ChunkUtils.toSectionRelativeCoordinate(x) / 4, ChunkUtils.toSectionRelativeCoordinate(y) / 4, ChunkUtils.toSectionRelativeCoordinate(z) / 4, id);
        }

        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            int localX = ChunkUtils.toSectionRelativeCoordinate(x);
            int localY = ChunkUtils.toSectionRelativeCoordinate(y);
            int localZ = ChunkUtils.toSectionRelativeCoordinate(z);
            this.handleCache(localX, localY, localZ, block);
            this.blockPalette.set(localX, localY, localZ, this.retrieveBlockId(block));
        }

        @Override
        public void setRelative(int x, int y, int z, @NotNull Block block) {
            this.handleCache(x, y, z, block);
            this.blockPalette.set(x, y, z, this.retrieveBlockId(block));
        }

        @Override
        public void setAllRelative(@NotNull UnitModifier.Supplier supplier) {
            this.blockPalette.setAll((int x, int y, int z) -> {
                Block block = supplier.get(x, y, z);
                this.handleCache(x, y, z, block);
                return this.retrieveBlockId(block);
            });
        }

        @Override
        public void fill(@NotNull Block block) {
            if (this.requireCache(block)) {
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            this.cache.put(ChunkUtils.getBlockIndex(x, y, z), (Object)block);
                        }
                    }
                }
            }
            this.blockPalette.fill(this.retrieveBlockId(block));
        }

        @Override
        public void fillBiome(@NotNull Biome biome) {
            if (this.fork) {
                throw new IllegalStateException("Cannot modify biomes of a fork");
            }
            int id = MinecraftServer.getBiomeManager().getId(biome);
            if (id == -1) {
                throw new IllegalStateException("Biome has not been registered: " + String.valueOf(biome.namespace()));
            }
            this.biomePalette.fill(id);
        }

        private int retrieveBlockId(Block block) {
            return this.fork ? block.stateId() + 1 : block.stateId();
        }

        private void handleCache(int x, int y, int z, Block block) {
            if (this.requireCache(block)) {
                this.cache.put(ChunkUtils.getBlockIndex(x, y, z), (Object)block);
            } else if (!this.cache.isEmpty()) {
                this.cache.remove(ChunkUtils.getBlockIndex(x, y, z));
            }
        }

        private boolean requireCache(Block block) {
            return block.hasNbt() || block.handler() != null || block.registry().isBlockEntity();
        }
    }

    record UnitImpl(UnitModifier modifier, Point size, Point absoluteStart, Point absoluteEnd, List<GenerationUnit> divided, List<UnitImpl> forks) implements GenerationUnit
    {
        @Override
        @NotNull
        public GenerationUnit fork(@NotNull Point start, @NotNull Point end) {
            int minSectionX = ChunkUtils.floorSection(start.blockX()) / 16;
            int minSectionY = ChunkUtils.floorSection(start.blockY()) / 16;
            int minSectionZ = ChunkUtils.floorSection(start.blockZ()) / 16;
            int maxSectionX = ChunkUtils.ceilSection(end.blockX()) / 16;
            int maxSectionY = ChunkUtils.ceilSection(end.blockY()) / 16;
            int maxSectionZ = ChunkUtils.ceilSection(end.blockZ()) / 16;
            int width = maxSectionX - minSectionX;
            int height = maxSectionY - minSectionY;
            int depth = maxSectionZ - minSectionZ;
            GenerationUnit[] units = new GenerationUnit[width * height * depth];
            int index = 0;
            for (int sectionX = minSectionX; sectionX < maxSectionX; ++sectionX) {
                for (int sectionY = minSectionY; sectionY < maxSectionY; ++sectionY) {
                    for (int sectionZ = minSectionZ; sectionZ < maxSectionZ; ++sectionZ) {
                        GenerationUnit unit = GeneratorImpl.section(new Section(), sectionX, sectionY, sectionZ, true);
                        units[index++] = unit;
                    }
                }
            }
            List<GenerationUnit> sections = List.of(units);
            Vec startSection = new Vec(minSectionX * 16, minSectionY * 16, minSectionZ * 16);
            return this.registerFork(startSection, sections, width, height, depth);
        }

        @Override
        public void fork(@NotNull @NotNull Consumer<@NotNull Block.Setter> consumer) {
            DynamicFork dynamicFork = new DynamicFork();
            consumer.accept(dynamicFork);
            Vec startSection = dynamicFork.minSection;
            if (startSection == null) {
                return;
            }
            int width = dynamicFork.width;
            int height = dynamicFork.height;
            int depth = dynamicFork.depth;
            List<GenerationUnit> sections = dynamicFork.sections;
            this.registerFork(startSection, sections, width, height, depth);
        }

        @Override
        @NotNull
        public List<GenerationUnit> subdivide() {
            return Objects.requireNonNullElseGet(this.divided, () -> GenerationUnit.super.subdivide());
        }

        private GenerationUnit registerFork(Point start, List<GenerationUnit> sections, int width, int height, int depth) {
            Point end = start.add(width * 16, height * 16, depth * 16);
            Point size = end.sub(start);
            AreaModifierImpl modifier = new AreaModifierImpl(null, size, start, end, width, height, depth, sections);
            UnitImpl fork = new UnitImpl(modifier, size, start, end, sections, this.forks);
            this.forks.add(fork);
            return fork;
        }
    }

    record AreaModifierImpl(Chunk chunk, Point size, Point start, Point end, int width, int height, int depth, List<GenerationUnit> sections) implements GenericModifier
    {
        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            this.checkBorder(x, y, z);
            GenerationUnit section = this.findAbsoluteSection(x, y, z);
            y = (int)((double)y - this.start.y());
            section.modifier().setBlock(x, y, z, block);
        }

        @Override
        public void setBiome(int x, int y, int z, @NotNull Biome biome) {
            this.checkBorder(x, y, z);
            GenerationUnit section = this.findAbsoluteSection(x, y, z);
            y = (int)((double)y - this.start.y());
            section.modifier().setBiome(x, y, z, biome);
        }

        @Override
        public void setRelative(int x, int y, int z, @NotNull Block block) {
            if (x < 0 || (double)x >= this.size.x() || y < 0 || (double)y >= this.size.y() || z < 0 || (double)z >= this.size.z()) {
                throw new IllegalArgumentException("x, y and z must be in the chunk: " + x + ", " + y + ", " + z);
            }
            GenerationUnit section = this.findRelativeSection(x, y, z);
            x = ChunkUtils.toSectionRelativeCoordinate(x);
            y = ChunkUtils.toSectionRelativeCoordinate(y);
            z = ChunkUtils.toSectionRelativeCoordinate(z);
            section.modifier().setBlock(x, y, z, block);
        }

        @Override
        public void setAll(@NotNull UnitModifier.Supplier supplier) {
            for (GenerationUnit section : this.sections) {
                Point start = section.absoluteStart();
                int startX = start.blockX();
                int startY = start.blockY();
                int startZ = start.blockZ();
                section.modifier().setAllRelative((x, y, z) -> supplier.get(x + startX, y + startY, z + startZ));
            }
        }

        @Override
        public void setAllRelative(@NotNull UnitModifier.Supplier supplier) {
            Point start = this.start;
            for (GenerationUnit section : this.sections) {
                Point sectionStart = section.absoluteStart();
                int offsetX = sectionStart.blockX() - start.blockX();
                int offsetY = sectionStart.blockY() - start.blockY();
                int offsetZ = sectionStart.blockZ() - start.blockZ();
                section.modifier().setAllRelative((x, y, z) -> supplier.get(x + offsetX, y + offsetY, z + offsetZ));
            }
        }

        @Override
        public void fill(@NotNull Block block) {
            for (GenerationUnit section : this.sections) {
                section.modifier().fill(block);
            }
        }

        @Override
        public void fillBiome(@NotNull Biome biome) {
            for (GenerationUnit section : this.sections) {
                section.modifier().fillBiome(biome);
            }
        }

        @Override
        public void fillHeight(int minHeight, int maxHeight, @NotNull Block block) {
            boolean endOffset;
            Point start = this.start;
            int width = this.width;
            int depth = this.depth;
            int startX = start.blockX();
            int startZ = start.blockZ();
            int minMultiple = ChunkUtils.floorSection(minHeight);
            int maxMultiple = ChunkUtils.ceilSection(maxHeight);
            boolean startOffset = minMultiple != minHeight;
            boolean bl = endOffset = maxMultiple != maxHeight;
            if (startOffset || endOffset) {
                int firstFill = Math.min(minMultiple + 16, maxHeight);
                int lastFill = startOffset ? Math.max(firstFill, ChunkUtils.floorSection(maxHeight)) : ChunkUtils.floorSection(maxHeight);
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < depth; ++z) {
                        GenerationUnit section;
                        int sectionX = startX + x * 16;
                        int sectionZ = startZ + z * 16;
                        if (startOffset) {
                            section = this.findAbsoluteSection(sectionX, minMultiple, sectionZ);
                            section.modifier().fillHeight(minHeight, firstFill, block);
                        }
                        if (!endOffset) continue;
                        section = this.findAbsoluteSection(sectionX, maxHeight, sectionZ);
                        section.modifier().fillHeight(lastFill, maxHeight, block);
                    }
                }
            }
            int startSection = minMultiple / 16 + (startOffset ? 1 : 0);
            int endSection = maxMultiple / 16 + (endOffset ? -1 : 0);
            for (int i = startSection; i < endSection; ++i) {
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < depth; ++z) {
                        GenerationUnit section = this.findAbsoluteSection(startX + x * 16, i * 16, startZ + z * 16);
                        section.modifier().fill(block);
                    }
                }
            }
        }

        private GenerationUnit findAbsoluteSection(int x, int y, int z) {
            return GeneratorImpl.findAbsolute(this.sections, this.start, this.width, this.height, this.depth, x, y, z);
        }

        private GenerationUnit findRelativeSection(int x, int y, int z) {
            int sectionX = ChunkUtils.getChunkCoordinate(x);
            int sectionY = ChunkUtils.getChunkCoordinate(y);
            int sectionZ = ChunkUtils.getChunkCoordinate(z);
            int index = sectionZ + sectionY * this.depth + sectionX * this.depth * this.height;
            return this.sections.get(index);
        }

        private void checkBorder(int x, int y, int z) {
            if ((double)x < this.start.x() || (double)x >= this.end.x() || (double)y < this.start.y() || (double)y >= this.end.y() || (double)z < this.start.z() || (double)z >= this.end.z()) {
                String format = String.format("Invalid coordinates: %d, %d, %d for area %s %s", x, y, z, this.start, this.end);
                throw new IllegalArgumentException(format);
            }
        }
    }

    static sealed interface GenericModifier
    extends UnitModifier
    permits AreaModifierImpl, SectionModifierImpl {
        public Point size();

        public Point start();

        public Point end();

        @Override
        default public void setAll(@NotNull UnitModifier.Supplier supplier) {
            Point start = this.start();
            Point end = this.end();
            int endX = end.blockX();
            int endY = end.blockY();
            int endZ = end.blockZ();
            for (int x = start.blockX(); x < endX; ++x) {
                for (int y = start.blockY(); y < endY; ++y) {
                    for (int z = start.blockZ(); z < endZ; ++z) {
                        this.setBlock(x, y, z, supplier.get(x, y, z));
                    }
                }
            }
        }

        @Override
        default public void setAllRelative(@NotNull UnitModifier.Supplier supplier) {
            Point size = this.size();
            int endX = size.blockX();
            int endY = size.blockY();
            int endZ = size.blockZ();
            for (int x = 0; x < endX; ++x) {
                for (int y = 0; y < endY; ++y) {
                    for (int z = 0; z < endZ; ++z) {
                        this.setRelative(x, y, z, supplier.get(x, y, z));
                    }
                }
            }
        }

        @Override
        default public void fill(@NotNull Block block) {
            this.fill(this.start(), this.end(), block);
        }

        @Override
        default public void fill(@NotNull Point start, @NotNull Point end, @NotNull Block block) {
            int endX = end.blockX();
            int endY = end.blockY();
            int endZ = end.blockZ();
            for (int x = start.blockX(); x < endX; ++x) {
                for (int y = start.blockY(); y < endY; ++y) {
                    for (int z = start.blockZ(); z < endZ; ++z) {
                        this.setBlock(x, y, z, block);
                    }
                }
            }
        }

        @Override
        default public void fillHeight(int minHeight, int maxHeight, @NotNull Block block) {
            Point start = this.start();
            Point end = this.end();
            int startY = start.blockY();
            int endY = end.blockY();
            if (startY >= minHeight && endY <= maxHeight) {
                this.fill(start, end, block);
            } else {
                this.fill(start.withY(Math.max(minHeight, startY)), end.withY(Math.min(maxHeight, endY)), block);
            }
        }
    }

    static final class DynamicFork
    implements Block.Setter {
        Vec minSection;
        int width;
        int height;
        int depth;
        List<GenerationUnit> sections;

        DynamicFork() {
        }

        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            this.resize(x, y, z);
            GenerationUnit section = GeneratorImpl.findAbsolute(this.sections, this.minSection, this.width, this.height, this.depth, x, y, z);
            assert (section.absoluteStart().chunkX() == ChunkUtils.getChunkCoordinate(x) && section.absoluteStart().section() == ChunkUtils.getChunkCoordinate(y) && section.absoluteStart().chunkZ() == ChunkUtils.getChunkCoordinate(z)) : "Invalid section " + String.valueOf(section.absoluteStart()) + " for " + x + ", " + y + ", " + z;
            section.modifier().setBlock(x, y, z, block);
        }

        private void resize(int x, int y, int z) {
            int sectionX = ChunkUtils.getChunkCoordinate(x);
            int sectionY = ChunkUtils.getChunkCoordinate(y);
            int sectionZ = ChunkUtils.getChunkCoordinate(z);
            if (this.sections == null) {
                this.minSection = new Vec(sectionX * 16, sectionY * 16, sectionZ * 16);
                this.width = 1;
                this.height = 1;
                this.depth = 1;
                this.sections = List.of(GeneratorImpl.section(new Section(), sectionX, sectionY, sectionZ, true));
            } else if ((double)x < this.minSection.x() || (double)y < this.minSection.y() || (double)z < this.minSection.z() || (double)x >= this.minSection.x() + (double)(this.width * 16) || (double)y >= this.minSection.y() + (double)(this.height * 16) || (double)z >= this.minSection.z() + (double)(this.depth * 16)) {
                Vec newMin = new Vec(Math.min(this.minSection.x(), (double)(sectionX * 16)), Math.min(this.minSection.y(), (double)(sectionY * 16)), Math.min(this.minSection.z(), (double)(sectionZ * 16)));
                Vec newMax = new Vec(Math.max(this.minSection.x() + (double)(this.width * 16), (double)(sectionX * 16 + 16)), Math.max(this.minSection.y() + (double)(this.height * 16), (double)(sectionY * 16 + 16)), Math.max(this.minSection.z() + (double)(this.depth * 16), (double)(sectionZ * 16 + 16)));
                int newWidth = ChunkUtils.getChunkCoordinate(newMax.x() - newMin.x());
                int newHeight = ChunkUtils.getChunkCoordinate(newMax.y() - newMin.y());
                int newDepth = ChunkUtils.getChunkCoordinate(newMax.z() - newMin.z());
                GenerationUnit[] newSections = new GenerationUnit[newWidth * newHeight * newDepth];
                for (GenerationUnit s : this.sections) {
                    Point start = s.absoluteStart();
                    int newX = ChunkUtils.getChunkCoordinate(start.x() - newMin.x());
                    int newY = ChunkUtils.getChunkCoordinate(start.y() - newMin.y());
                    int newZ = ChunkUtils.getChunkCoordinate(start.z() - newMin.z());
                    int index = GeneratorImpl.findIndex(newWidth, newHeight, newDepth, newX, newY, newZ);
                    newSections[index] = s;
                }
                int startX = newMin.chunkX();
                int startY = newMin.section();
                int startZ = newMin.chunkZ();
                for (int i = 0; i < newSections.length; ++i) {
                    GenerationUnit unit;
                    if (newSections[i] != null) continue;
                    Point coordinates = GeneratorImpl.to3D(i, newWidth, newHeight, newDepth);
                    int newX = coordinates.blockX() + startX;
                    int newY = coordinates.blockY() + startY;
                    int newZ = coordinates.blockZ() + startZ;
                    newSections[i] = unit = GeneratorImpl.section(new Section(), newX, newY, newZ, true);
                }
                this.sections = List.of(newSections);
                this.minSection = newMin;
                this.width = newWidth;
                this.height = newHeight;
                this.depth = newDepth;
            }
        }
    }
}

