/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.pointer.Pointers;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerProcess;
import net.minestom.server.Tickable;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ExperienceOrb;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.pathfinding.PFInstanceSpace;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventHandler;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.instance.InstanceTickEvent;
import net.minestom.server.event.trait.InstanceEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.EntityTrackerImpl;
import net.minestom.server.instance.Explosion;
import net.minestom.server.instance.ExplosionSupplier;
import net.minestom.server.instance.LightingChunk;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.Weather;
import net.minestom.server.instance.WorldBorder;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.generator.Generator;
import net.minestom.server.instance.light.Light;
import net.minestom.server.network.packet.server.play.BlockActionPacket;
import net.minestom.server.network.packet.server.play.TimeUpdatePacket;
import net.minestom.server.snapshot.ChunkSnapshot;
import net.minestom.server.snapshot.InstanceSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.snapshot.Snapshotable;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import net.minestom.server.timer.Schedulable;
import net.minestom.server.timer.Scheduler;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.chunk.ChunkCache;
import net.minestom.server.utils.chunk.ChunkSupplier;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.utils.time.Cooldown;
import net.minestom.server.utils.time.TimeUnit;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Instance
implements Block.Getter,
Block.Setter,
Tickable,
Schedulable,
Snapshotable,
EventHandler<InstanceEvent>,
Taggable,
PacketGroupingAudience {
    private boolean registered;
    private final DimensionType dimensionType;
    private final String dimensionName;
    private final WorldBorder worldBorder;
    private long worldAge;
    private long time;
    private int timeRate = 1;
    private Duration timeUpdate = Duration.of(1L, TimeUnit.SECOND);
    private long lastTimeUpdate;
    private Weather weather = Weather.CLEAR;
    private Weather transitioningWeather = Weather.CLEAR;
    private int remainingRainTransitionTicks;
    private int remainingThunderTransitionTicks;
    private long lastTickAge = System.currentTimeMillis();
    private final EntityTracker entityTracker = new EntityTrackerImpl();
    private final ChunkCache blockRetriever = new ChunkCache(this, null, null);
    protected UUID uniqueId;
    protected TagHandler tagHandler = TagHandler.newHandler();
    private final Scheduler scheduler = Scheduler.newScheduler();
    private final EventNode<InstanceEvent> eventNode;
    private ExplosionSupplier explosionSupplier;
    private final PFInstanceSpace instanceSpace = new PFInstanceSpace(this);
    private final Pointers pointers;

    public Instance(@NotNull UUID uniqueId, @NotNull DimensionType dimensionType) {
        this(uniqueId, dimensionType, dimensionType.getName());
    }

    public Instance(@NotNull UUID uniqueId, @NotNull DimensionType dimensionType, @NotNull NamespaceID dimensionName) {
        Check.argCondition(!dimensionType.isRegistered(), "The dimension " + String.valueOf(dimensionType.getName()) + " is not registered! Please use DimensionTypeManager#addDimension");
        this.uniqueId = uniqueId;
        this.dimensionType = dimensionType;
        this.dimensionName = dimensionName.asString();
        this.worldBorder = new WorldBorder(this);
        this.pointers = (Pointers)Pointers.builder().withDynamic(Identity.UUID, this::getUniqueId).build();
        ServerProcess process = MinecraftServer.process();
        this.eventNode = process != null ? process.eventHandler().map(this, (EventFilter)EventFilter.INSTANCE) : null;
    }

    public void scheduleNextTick(@NotNull Consumer<Instance> callback) {
        this.scheduler.scheduleNextTick(() -> callback.accept(this));
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block) {
        this.setBlock(x, y, z, block, true);
    }

    public void setBlock(@NotNull Point blockPosition, @NotNull Block block, boolean doBlockUpdates) {
        this.setBlock(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), block, doBlockUpdates);
    }

    public abstract void setBlock(int var1, int var2, int var3, @NotNull Block var4, boolean var5);

    @ApiStatus.Internal
    public boolean placeBlock(@NotNull BlockHandler.Placement placement) {
        return this.placeBlock(placement, true);
    }

    @ApiStatus.Internal
    public abstract boolean placeBlock(@NotNull BlockHandler.Placement var1, boolean var2);

    @ApiStatus.Internal
    public boolean breakBlock(@NotNull Player player, @NotNull Point blockPosition, @NotNull BlockFace blockFace) {
        return this.breakBlock(player, blockPosition, blockFace, true);
    }

    @ApiStatus.Internal
    public abstract boolean breakBlock(@NotNull Player var1, @NotNull Point var2, @NotNull BlockFace var3, boolean var4);

    @NotNull
    public abstract @NotNull CompletableFuture<@NotNull Chunk> loadChunk(int var1, int var2);

    @NotNull
    public @NotNull CompletableFuture<@NotNull Chunk> loadChunk(@NotNull Point point) {
        return this.loadChunk(point.chunkX(), point.chunkZ());
    }

    public abstract @NotNull CompletableFuture<@Nullable Chunk> loadOptionalChunk(int var1, int var2);

    public @NotNull CompletableFuture<@Nullable Chunk> loadOptionalChunk(@NotNull Point point) {
        return this.loadOptionalChunk(point.chunkX(), point.chunkZ());
    }

    public abstract void unloadChunk(@NotNull Chunk var1);

    public void unloadChunk(int chunkX, int chunkZ) {
        Chunk chunk = this.getChunk(chunkX, chunkZ);
        Check.notNull(chunk, "The chunk at {0}:{1} is already unloaded", chunkX, chunkZ);
        this.unloadChunk(chunk);
    }

    @Nullable
    public abstract Chunk getChunk(int var1, int var2);

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ) != null;
    }

    public boolean isChunkLoaded(Point point) {
        return this.isChunkLoaded(point.chunkX(), point.chunkZ());
    }

    @ApiStatus.Experimental
    @NotNull
    public abstract CompletableFuture<Void> saveInstance();

    @NotNull
    public abstract CompletableFuture<Void> saveChunkToStorage(@NotNull Chunk var1);

    @NotNull
    public abstract CompletableFuture<Void> saveChunksToStorage();

    public abstract void setChunkSupplier(@NotNull ChunkSupplier var1);

    public abstract ChunkSupplier getChunkSupplier();

    @Nullable
    public abstract Generator generator();

    public abstract void setGenerator(@Nullable Generator var1);

    @NotNull
    public abstract @NotNull Collection<@NotNull Chunk> getChunks();

    public abstract void enableAutoChunkLoad(boolean var1);

    public abstract boolean hasEnabledAutoChunkLoad();

    public abstract boolean isInVoid(@NotNull Point var1);

    public boolean isRegistered() {
        return this.registered;
    }

    protected void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @NotNull
    public String getDimensionName() {
        return this.dimensionName;
    }

    public long getWorldAge() {
        return this.worldAge;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
        PacketUtils.sendGroupedPacket(this.getPlayers(), this.createTimePacket());
    }

    public int getTimeRate() {
        return this.timeRate;
    }

    public void setTimeRate(int timeRate) {
        Check.stateCondition(timeRate < 0, "The time rate cannot be lower than 0");
        this.timeRate = timeRate;
    }

    @Nullable
    public Duration getTimeUpdate() {
        return this.timeUpdate;
    }

    public void setTimeUpdate(@Nullable Duration timeUpdate) {
        this.timeUpdate = timeUpdate;
    }

    @ApiStatus.Internal
    @NotNull
    public TimeUpdatePacket createTimePacket() {
        long time = this.time;
        if (this.timeRate == 0) {
            time = time == 0L ? -24000L : -Math.abs(time);
        }
        return new TimeUpdatePacket(this.worldAge, time);
    }

    @NotNull
    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    @NotNull
    public @NotNull Set<@NotNull Entity> getEntities() {
        return this.entityTracker.entities();
    }

    @NotNull
    public @NotNull Set<@NotNull Player> getPlayers() {
        return this.entityTracker.entities(EntityTracker.Target.PLAYERS);
    }

    @Deprecated
    @NotNull
    public @NotNull Set<@NotNull EntityCreature> getCreatures() {
        return this.entityTracker.entities().stream().filter(EntityCreature.class::isInstance).map(entity -> (EntityCreature)entity).collect(Collectors.toUnmodifiableSet());
    }

    @Deprecated
    @NotNull
    public @NotNull Set<@NotNull ExperienceOrb> getExperienceOrbs() {
        return this.entityTracker.entities().stream().filter(ExperienceOrb.class::isInstance).map(entity -> (ExperienceOrb)entity).collect(Collectors.toUnmodifiableSet());
    }

    @NotNull
    public @NotNull Set<@NotNull Entity> getChunkEntities(Chunk chunk) {
        Collection<Entity> chunkEntities = this.entityTracker.chunkEntities(chunk.toPosition(), EntityTracker.Target.ENTITIES);
        return ObjectArraySet.ofUnchecked((Object[])((Entity[])chunkEntities.toArray(Entity[]::new)));
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull Point point, double range) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        this.entityTracker.nearbyEntities(point, range, EntityTracker.Target.ENTITIES, result::add);
        return result;
    }

    @Override
    @Nullable
    public Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
        Block block = this.blockRetriever.getBlock(x, y, z, condition);
        if (block == null) {
            throw new NullPointerException("Unloaded chunk at " + x + "," + y + "," + z);
        }
        return block;
    }

    public void sendBlockAction(@NotNull Point blockPosition, byte actionId, byte actionParam) {
        Block block = this.getBlock(blockPosition);
        Chunk chunk = this.getChunkAt(blockPosition);
        Check.notNull(chunk, "The chunk at {0} is not loaded!", blockPosition);
        chunk.sendPacketToViewers(new BlockActionPacket(blockPosition, actionId, actionParam, block));
    }

    @Nullable
    public Chunk getChunkAt(double x, double z) {
        return this.getChunk(ChunkUtils.getChunkCoordinate(x), ChunkUtils.getChunkCoordinate(z));
    }

    @Nullable
    public Chunk getChunkAt(@NotNull Point point) {
        return this.getChunk(point.chunkX(), point.chunkZ());
    }

    @ApiStatus.Experimental
    public EntityTracker getEntityTracker() {
        return this.entityTracker;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void tick(long time) {
        this.scheduler.processTick();
        ++this.worldAge;
        this.time += (long)this.timeRate;
        if (this.timeUpdate != null && !Cooldown.hasCooldown(time, this.lastTimeUpdate, this.timeUpdate)) {
            PacketUtils.sendGroupedPacket(this.getPlayers(), this.createTimePacket());
            this.lastTimeUpdate = time;
        }
        if (this.remainingRainTransitionTicks > 0 || this.remainingThunderTransitionTicks > 0) {
            Weather previousWeather = this.transitioningWeather;
            this.transitioningWeather = this.transitionWeather(this.remainingRainTransitionTicks, this.remainingThunderTransitionTicks);
            this.sendWeatherPackets(previousWeather);
            this.remainingRainTransitionTicks = Math.max(0, this.remainingRainTransitionTicks - 1);
            this.remainingThunderTransitionTicks = Math.max(0, this.remainingThunderTransitionTicks - 1);
        }
        EventDispatcher.call(new InstanceTickEvent(this, time, this.lastTickAge));
        this.lastTickAge = time;
        this.worldBorder.update();
        this.scheduler.processTickEnd();
    }

    @NotNull
    public Weather getWeather() {
        return this.weather;
    }

    public void setWeather(@NotNull Weather weather, int transitionTicks) {
        Check.stateCondition(transitionTicks < 1, "Transition ticks cannot be lower than 0");
        this.weather = weather;
        this.remainingRainTransitionTicks = transitionTicks;
        this.remainingThunderTransitionTicks = transitionTicks;
    }

    public void setWeather(@NotNull Weather weather) {
        this.weather = weather;
        this.remainingRainTransitionTicks = (int)Math.max(1.0, Math.abs((double)(this.weather.rainLevel() - this.transitioningWeather.rainLevel()) / 0.01));
        this.remainingThunderTransitionTicks = (int)Math.max(1.0, Math.abs((double)(this.weather.thunderLevel() - this.transitioningWeather.thunderLevel()) / 0.01));
    }

    private void sendWeatherPackets(@NotNull Weather previousWeather) {
        boolean toggledRain;
        boolean bl = toggledRain = this.transitioningWeather.isRaining() != previousWeather.isRaining();
        if (toggledRain) {
            this.sendGroupedPacket(this.transitioningWeather.createIsRainingPacket());
        }
        if (this.transitioningWeather.rainLevel() != previousWeather.rainLevel()) {
            this.sendGroupedPacket(this.transitioningWeather.createRainLevelPacket());
        }
        if (this.transitioningWeather.thunderLevel() != previousWeather.thunderLevel()) {
            this.sendGroupedPacket(this.transitioningWeather.createThunderLevelPacket());
        }
    }

    @NotNull
    private Weather transitionWeather(int remainingRainTransitionTicks, int remainingThunderTransitionTicks) {
        Weather target = this.weather;
        Weather current = this.transitioningWeather;
        float rainLevel = current.rainLevel() + (target.rainLevel() - current.rainLevel()) * (1.0f / (float)Math.max(1, remainingRainTransitionTicks));
        float thunderLevel = current.thunderLevel() + (target.thunderLevel() - current.thunderLevel()) * (1.0f / (float)Math.max(1, remainingThunderTransitionTicks));
        return new Weather(rainLevel, thunderLevel);
    }

    @Override
    @NotNull
    public TagHandler tagHandler() {
        return this.tagHandler;
    }

    @Override
    @NotNull
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public EventNode<InstanceEvent> eventNode() {
        return this.eventNode;
    }

    @Override
    @NotNull
    public InstanceSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        Map<Long, AtomicReference<ChunkSnapshot>> chunksMap = updater.referencesMapLong(this.getChunks(), ChunkUtils::getChunkIndex);
        int[] entities = ArrayUtils.mapToIntArray(this.entityTracker.entities(), Entity::getEntityId);
        return new SnapshotImpl.Instance(updater.reference(MinecraftServer.process()), this.getDimensionType(), this.getWorldAge(), this.getTime(), chunksMap, entities, this.tagHandler.readableCopy());
    }

    public void explode(float centerX, float centerY, float centerZ, float strength) {
        this.explode(centerX, centerY, centerZ, strength, null);
    }

    public void explode(float centerX, float centerY, float centerZ, float strength, @Nullable CompoundBinaryTag additionalData) {
        ExplosionSupplier explosionSupplier = this.getExplosionSupplier();
        Check.stateCondition(explosionSupplier == null, "Tried to create an explosion with no explosion supplier");
        Explosion explosion = explosionSupplier.createExplosion(centerX, centerY, centerZ, strength, additionalData);
        explosion.apply(this);
    }

    @Nullable
    public ExplosionSupplier getExplosionSupplier() {
        return this.explosionSupplier;
    }

    public void setExplosionSupplier(@Nullable ExplosionSupplier supplier) {
        this.explosionSupplier = supplier;
    }

    @ApiStatus.Internal
    @NotNull
    public PFInstanceSpace getInstanceSpace() {
        return this.instanceSpace;
    }

    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }

    public int getBlockLight(int blockX, int blockY, int blockZ) {
        Chunk chunk = this.getChunkAt(blockX, blockZ);
        if (chunk == null) {
            return 0;
        }
        Section section = chunk.getSectionAt(blockY);
        Light light = section.blockLight();
        int sectionCoordinate = ChunkUtils.getChunkCoordinate(blockY);
        int coordX = ChunkUtils.toSectionRelativeCoordinate(blockX);
        int coordY = ChunkUtils.toSectionRelativeCoordinate(blockY);
        int coordZ = ChunkUtils.toSectionRelativeCoordinate(blockZ);
        if (light.requiresUpdate()) {
            LightingChunk.relightSection(chunk.getInstance(), chunk.chunkX, sectionCoordinate, chunk.chunkZ);
        }
        return light.getLevel(coordX, coordY, coordZ);
    }

    public int getSkyLight(int blockX, int blockY, int blockZ) {
        Chunk chunk = this.getChunkAt(blockX, blockZ);
        if (chunk == null) {
            return 0;
        }
        Section section = chunk.getSectionAt(blockY);
        Light light = section.skyLight();
        int sectionCoordinate = ChunkUtils.getChunkCoordinate(blockY);
        int coordX = ChunkUtils.toSectionRelativeCoordinate(blockX);
        int coordY = ChunkUtils.toSectionRelativeCoordinate(blockY);
        int coordZ = ChunkUtils.toSectionRelativeCoordinate(blockZ);
        if (light.requiresUpdate()) {
            LightingChunk.relightSection(chunk.getInstance(), chunk.chunkX, sectionCoordinate, chunk.chunkZ);
        }
        return light.getLevel(coordX, coordY, coordZ);
    }
}

