/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import net.minestom.server.ServerFlag;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.Instance;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.InitializeWorldBorderPacket;
import net.minestom.server.network.packet.server.play.WorldBorderCenterPacket;
import net.minestom.server.network.packet.server.play.WorldBorderLerpSizePacket;
import net.minestom.server.network.packet.server.play.WorldBorderSizePacket;
import net.minestom.server.network.packet.server.play.WorldBorderWarningDelayPacket;
import net.minestom.server.network.packet.server.play.WorldBorderWarningReachPacket;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WorldBorder {
    private final Instance instance;
    private float centerX;
    private float centerZ;
    private volatile double currentDiameter;
    private double oldDiameter;
    private double newDiameter;
    private long lerpStartTime;
    private long speed;
    private final int portalTeleportBoundary;
    private int warningTime;
    private int warningBlocks;

    protected WorldBorder(@NotNull Instance instance) {
        this.instance = instance;
        this.oldDiameter = Double.MAX_VALUE;
        this.newDiameter = Double.MAX_VALUE;
        this.speed = 0L;
        this.portalTeleportBoundary = ServerFlag.WORLD_BORDER_SIZE;
        this.update();
    }

    public void setCenter(float centerX, float centerZ) {
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.refreshCenter();
    }

    public float getCenterX() {
        return this.centerX;
    }

    public void setCenterX(float centerX) {
        this.centerX = centerX;
        this.refreshCenter();
    }

    public float getCenterZ() {
        return this.centerZ;
    }

    public void setCenterZ(float centerZ) {
        this.centerZ = centerZ;
        this.refreshCenter();
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public void setWarningTime(int warningTime) {
        this.warningTime = warningTime;
        this.sendPacket(new WorldBorderWarningDelayPacket(warningTime));
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }

    public void setWarningBlocks(int warningBlocks) {
        this.warningBlocks = warningBlocks;
        this.sendPacket(new WorldBorderWarningReachPacket(warningBlocks));
    }

    public void setDiameter(double diameter, long speed) {
        if (speed <= 0L) {
            this.setDiameter(diameter);
            return;
        }
        this.newDiameter = diameter;
        this.speed = speed;
        this.lerpStartTime = System.currentTimeMillis();
        this.sendPacket(new WorldBorderLerpSizePacket(this.oldDiameter, this.newDiameter, speed));
    }

    public double getDiameter() {
        return this.currentDiameter;
    }

    public void setDiameter(double diameter) {
        this.currentDiameter = diameter;
        this.oldDiameter = diameter;
        this.newDiameter = diameter;
        this.lerpStartTime = 0L;
        this.sendPacket(new WorldBorderSizePacket(diameter));
    }

    @NotNull
    public CollisionAxis getCollisionAxis(@NotNull Point point) {
        boolean checkZ;
        double radius = this.getDiameter() / 2.0;
        boolean checkX = point.x() <= (double)this.getCenterX() + radius && point.x() >= (double)this.getCenterX() - radius;
        boolean bl = checkZ = point.z() <= (double)this.getCenterZ() + radius && point.z() >= (double)this.getCenterZ() - radius;
        if (!checkX || !checkZ) {
            if (!checkX && !checkZ) {
                return CollisionAxis.BOTH;
            }
            if (!checkX) {
                return CollisionAxis.X;
            }
            return CollisionAxis.Z;
        }
        return CollisionAxis.NONE;
    }

    public boolean isInside(@NotNull Point point) {
        return this.getCollisionAxis(point) == CollisionAxis.NONE;
    }

    public boolean isInside(@NotNull Entity entity) {
        return this.isInside(entity.getPosition());
    }

    protected void update() {
        if (this.lerpStartTime == 0L) {
            this.currentDiameter = this.oldDiameter;
        } else {
            double diameterDelta = this.newDiameter - this.oldDiameter;
            long elapsedTime = System.currentTimeMillis() - this.lerpStartTime;
            double percentage = (double)elapsedTime / (double)this.speed;
            if (percentage > 0.99) {
                this.lerpStartTime = 0L;
                this.speed = 0L;
                this.oldDiameter = this.newDiameter;
                this.currentDiameter = this.newDiameter;
            } else {
                this.currentDiameter = this.oldDiameter + diameterDelta * percentage;
            }
        }
    }

    @ApiStatus.Internal
    public void init(@NotNull Player player) {
        player.sendPacket(new InitializeWorldBorderPacket(this.centerX, this.centerZ, this.oldDiameter, this.newDiameter, this.speed, this.portalTeleportBoundary, this.warningTime, this.warningBlocks));
    }

    @NotNull
    public Instance getInstance() {
        return this.instance;
    }

    private void refreshCenter() {
        this.sendPacket(new WorldBorderCenterPacket(this.centerX, this.centerZ));
    }

    private void sendPacket(@NotNull ServerPacket packet) {
        PacketUtils.sendGroupedPacket(this.instance.getPlayers(), packet);
    }

    public static enum CollisionAxis {
        X,
        Z,
        BOTH,
        NONE;

    }
}

