/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.anvil;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.IChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.anvil.RegionFile;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biomes.Biome;
import net.minestom.server.world.biomes.BiomeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnvilLoader
implements IChunkLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnvilLoader.class);
    private static final BiomeManager BIOME_MANAGER = MinecraftServer.getBiomeManager();
    private static final Biome PLAINS = BIOME_MANAGER.getByName(NamespaceID.from("minecraft:plains"));
    private final Map<String, RegionFile> alreadyLoaded = new ConcurrentHashMap<String, RegionFile>();
    private final Path path;
    private final Path levelPath;
    private final Path regionPath;
    private final RegionCache perRegionLoadedChunks = new RegionCache();
    private final ReentrantLock perRegionLoadedChunksLock = new ReentrantLock();
    private final ThreadLocal<Int2ObjectMap<CompoundBinaryTag>> blockStateId2ObjectCacheTLS = ThreadLocal.withInitial(Int2ObjectArrayMap::new);

    public AnvilLoader(@NotNull Path path) {
        this.path = path;
        this.levelPath = path.resolve("level.dat");
        this.regionPath = path.resolve("region");
    }

    public AnvilLoader(@NotNull String path) {
        this(Path.of(path, new String[0]));
    }

    @Override
    public void loadInstance(@NotNull Instance instance) {
        if (!Files.exists(this.levelPath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = Files.newInputStream(this.levelPath, new OpenOption[0]);){
            CompoundBinaryTag tag = (CompoundBinaryTag)BinaryTagIO.reader().readNamed(is, BinaryTagIO.Compression.GZIP).getValue();
            Files.copy(this.levelPath, this.path.resolve("level.dat_old"), StandardCopyOption.REPLACE_EXISTING);
            instance.tagHandler().updateContent(tag);
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    @Override
    public @NotNull CompletableFuture<@Nullable Chunk> loadChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return this.loadMCA(instance, chunkX, chunkZ);
        }
        catch (Exception e) {
            MinecraftServer.getExceptionManager().handleException(e);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NotNull CompletableFuture<@Nullable Chunk> loadMCA(Instance instance, int chunkX, int chunkZ) throws IOException {
        Chunk chunk;
        RegionFile mcaFile = this.getMCAFile(chunkX, chunkZ);
        if (mcaFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompoundBinaryTag chunkData = mcaFile.readChunkData(chunkX, chunkZ);
        if (chunkData == null) {
            return CompletableFuture.completedFuture(null);
        }
        Chunk chunk2 = chunk = instance.getChunkSupplier().createChunk(instance, chunkX, chunkZ);
        synchronized (chunk2) {
            String status = chunkData.getString("status");
            if (status.isEmpty() || "minecraft:full".equals(status)) {
                this.loadSections(chunk, chunkData);
                this.loadBlockEntities(chunk, chunkData);
                chunk.loadHeightmapsFromNBT(chunkData.getCompound("Heightmaps"));
            } else {
                LOGGER.warn("Skipping partially generated chunk at {}, {} with status {}", new Object[]{chunkX, chunkZ, status});
            }
        }
        this.perRegionLoadedChunksLock.lock();
        try {
            int regionX = ChunkUtils.toRegionCoordinate(chunkX);
            int regionZ = ChunkUtils.toRegionCoordinate(chunkZ);
            Set chunks = this.perRegionLoadedChunks.computeIfAbsent(new IntIntImmutablePair(regionX, regionZ), r -> new HashSet());
            chunks.add(new IntIntImmutablePair(chunkX, chunkZ));
        }
        finally {
            this.perRegionLoadedChunksLock.unlock();
        }
        return CompletableFuture.completedFuture(chunk);
    }

    @Nullable
    private RegionFile getMCAFile(int chunkX, int chunkZ) {
        int regionX = ChunkUtils.toRegionCoordinate(chunkX);
        int regionZ = ChunkUtils.toRegionCoordinate(chunkZ);
        return this.alreadyLoaded.computeIfAbsent(RegionFile.getFileName(regionX, regionZ), n -> {
            Path regionPath = this.regionPath.resolve((String)n);
            if (!Files.exists(regionPath, new LinkOption[0])) {
                return null;
            }
            this.perRegionLoadedChunksLock.lock();
            try {
                Set previousVersion = this.perRegionLoadedChunks.put(new IntIntImmutablePair(regionX, regionZ), new HashSet());
                assert (previousVersion == null) : "The AnvilLoader cache should not already have data for this region.";
                RegionFile regionFile = new RegionFile(regionPath);
                return regionFile;
            }
            catch (IOException e) {
                MinecraftServer.getExceptionManager().handleException(e);
                RegionFile regionFile = null;
                return regionFile;
            }
            finally {
                this.perRegionLoadedChunksLock.unlock();
            }
        });
    }

    private void loadSections(@NotNull Chunk chunk, @NotNull CompoundBinaryTag chunkData) {
        for (BinaryTag sectionTag : chunkData.getList("sections", BinaryTagTypes.COMPOUND)) {
            CompoundBinaryTag biomesTag;
            ListBinaryTag biomePaletteTag;
            ProtocolObject[] convertedPalette;
            ByteArrayBinaryTag blockLightTag;
            ByteArrayBinaryTag skyLightTag;
            CompoundBinaryTag sectionData = (CompoundBinaryTag)sectionTag;
            int sectionY = sectionData.getInt("Y", Integer.MIN_VALUE);
            Check.stateCondition(sectionY == Integer.MIN_VALUE, "Missing section Y value");
            int yOffset = 16 * sectionY;
            if (sectionY < chunk.getMinSection() || sectionY >= chunk.getMaxSection()) continue;
            Section section = chunk.getSection(sectionY);
            BinaryTag binaryTag = sectionData.get("SkyLight");
            if (binaryTag instanceof ByteArrayBinaryTag && (skyLightTag = (ByteArrayBinaryTag)binaryTag).size() == 2048) {
                section.setSkyLight(skyLightTag.value());
            }
            if ((binaryTag = sectionData.get("BlockLight")) instanceof ByteArrayBinaryTag && (blockLightTag = (ByteArrayBinaryTag)binaryTag).size() == 2048) {
                section.setBlockLight(blockLightTag.value());
            }
            if ((convertedPalette = this.loadBiomePalette(biomePaletteTag = (biomesTag = sectionData.getCompound("biomes")).getList("palette", BinaryTagTypes.STRING))).length == 1) {
                section.biomePalette().fill(BIOME_MANAGER.getId(convertedPalette[0]));
            } else if (convertedPalette.length > 1) {
                long[] packedIndices = biomesTag.getLongArray("data");
                Check.stateCondition(packedIndices.length == 0, "Missing packed biomes data");
                int[] biomeIndices = new int[64];
                ArrayUtils.unpack(biomeIndices, packedIndices, packedIndices.length * 64 / biomeIndices.length);
                section.biomePalette().setAll((arg_0, arg_1, arg_2) -> AnvilLoader.lambda$loadSections$2((Biome[])convertedPalette, biomeIndices, arg_0, arg_1, arg_2));
            }
            CompoundBinaryTag blockStatesTag = sectionData.getCompound("block_states");
            ListBinaryTag blockPaletteTag = blockStatesTag.getList("palette", BinaryTagTypes.COMPOUND);
            convertedPalette = this.loadBlockPalette(blockPaletteTag);
            if (blockPaletteTag.size() == 1) {
                section.blockPalette().fill(convertedPalette[0].stateId());
                continue;
            }
            if (blockPaletteTag.size() <= 1) continue;
            long[] packedStates = blockStatesTag.getLongArray("data");
            Check.stateCondition(packedStates.length == 0, "Missing packed states data");
            int[] blockStateIndices = new int[4096];
            ArrayUtils.unpack(blockStateIndices, packedStates, packedStates.length * 64 / blockStateIndices.length);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        try {
                            int blockIndex = y * 16 * 16 + z * 16 + x;
                            int paletteIndex = blockStateIndices[blockIndex];
                            ProtocolObject block = convertedPalette[paletteIndex];
                            chunk.setBlock(x, y + yOffset, z, (Block)block);
                            continue;
                        }
                        catch (Exception e) {
                            MinecraftServer.getExceptionManager().handleException(e);
                        }
                    }
                }
            }
        }
    }

    private Block[] loadBlockPalette(@NotNull ListBinaryTag paletteTag) {
        Block[] convertedPalette = new Block[paletteTag.size()];
        for (int i = 0; i < convertedPalette.length; ++i) {
            BlockHandler handler;
            CompoundBinaryTag paletteEntry = paletteTag.getCompound(i);
            String blockName = paletteEntry.getString("Name");
            if (blockName.equals("minecraft:air")) {
                convertedPalette[i] = Block.AIR;
                continue;
            }
            Block block = Objects.requireNonNull(Block.fromNamespaceId(blockName), "Unknown block " + blockName);
            HashMap<String, String> properties = new HashMap<String, String>();
            CompoundBinaryTag propertiesNBT = paletteEntry.getCompound("Properties");
            for (Map.Entry property : propertiesNBT) {
                Object v = property.getValue();
                if (v instanceof StringBinaryTag) {
                    StringBinaryTag propertyValue = (StringBinaryTag)v;
                    properties.put((String)property.getKey(), propertyValue.value());
                    continue;
                }
                LOGGER.warn("Fail to parse block state properties {}, expected a string for {}, but contents were {}", new Object[]{propertiesNBT, property.getKey(), TagStringIOExt.writeTag((BinaryTag)property.getValue())});
            }
            if (!properties.isEmpty()) {
                block = block.withProperties(properties);
            }
            if ((handler = MinecraftServer.getBlockManager().getHandler(block.name())) != null) {
                block = block.withHandler(handler);
            }
            convertedPalette[i] = block;
        }
        return convertedPalette;
    }

    private Biome[] loadBiomePalette(@NotNull ListBinaryTag paletteTag) {
        Biome[] convertedPalette = new Biome[paletteTag.size()];
        for (int i = 0; i < convertedPalette.length; ++i) {
            String name = paletteTag.getString(i);
            convertedPalette[i] = Objects.requireNonNullElse(BIOME_MANAGER.getByName(name), PLAINS);
        }
        return convertedPalette;
    }

    private void loadBlockEntities(@NotNull Chunk loadedChunk, @NotNull CompoundBinaryTag chunkData) {
        for (BinaryTag blockEntityTag : chunkData.getList("block_entities", BinaryTagTypes.COMPOUND)) {
            CompoundBinaryTag trimmedTag;
            CompoundBinaryTag blockEntity = (CompoundBinaryTag)blockEntityTag;
            int x = blockEntity.getInt("x");
            int y = blockEntity.getInt("y");
            int z = blockEntity.getInt("z");
            Block block = loadedChunk.getBlock(x, y, z);
            BinaryTag binaryTag = blockEntity.get("id");
            if (binaryTag instanceof StringBinaryTag) {
                StringBinaryTag blockEntityId = (StringBinaryTag)binaryTag;
                BlockHandler handler = MinecraftServer.getBlockManager().getHandlerOrDummy(blockEntityId.value());
                block = block.withHandler(handler);
            }
            Block finalBlock = (trimmedTag = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(blockEntity)).remove("id")).remove("keepPacked")).remove("x")).remove("y")).remove("z")).build()).size() > 0 ? block.withNbt(trimmedTag) : block;
            loadedChunk.setBlock(x, y, z, finalBlock);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveInstance(@NotNull Instance instance) {
        CompoundBinaryTag nbt = instance.tagHandler().asCompound();
        if (nbt.size() == 0) {
            return AsyncUtils.VOID_FUTURE;
        }
        try (OutputStream os = Files.newOutputStream(this.levelPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            BinaryTagIO.writer().writeNamed(Map.entry("", nbt), os, BinaryTagIO.Compression.GZIP);
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
        return AsyncUtils.VOID_FUTURE;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveChunk(@NotNull Chunk chunk) {
        int chunkZ;
        int chunkX = chunk.getChunkX();
        RegionFile mcaFile = this.getMCAFile(chunkX, chunkZ = chunk.getChunkZ());
        if (mcaFile == null) {
            int regionX = ChunkUtils.toRegionCoordinate(chunkX);
            int regionZ = ChunkUtils.toRegionCoordinate(chunkZ);
            String regionFileName = RegionFile.getFileName(regionX, regionZ);
            try {
                Path regionFile = this.regionPath.resolve(regionFileName);
                if (!Files.exists(regionFile, new LinkOption[0])) {
                    Files.createDirectories(regionFile.getParent(), new FileAttribute[0]);
                    Files.createFile(regionFile, new FileAttribute[0]);
                }
                mcaFile = new RegionFile(regionFile);
                this.alreadyLoaded.put(regionFileName, mcaFile);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create region file for " + chunkX + ", " + chunkZ, (Throwable)e);
                MinecraftServer.getExceptionManager().handleException(e);
                return AsyncUtils.VOID_FUTURE;
            }
        }
        try {
            CompoundBinaryTag.Builder chunkData = CompoundBinaryTag.builder();
            chunkData.putInt("DataVersion", 3839);
            chunkData.putInt("xPos", chunkX);
            chunkData.putInt("zPos", chunkZ);
            chunkData.putInt("yPos", chunk.getMinSection());
            chunkData.putString("status", "minecraft:full");
            chunkData.putLong("LastUpdate", chunk.getInstance().getWorldAge());
            this.saveSectionData(chunk, chunkData);
            LOGGER.debug("Attempt saving at {} {}", (Object)chunk.getChunkX(), (Object)chunk.getChunkZ());
            mcaFile.writeChunkData(chunkX, chunkZ, chunkData.build());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save chunk " + chunkX + ", " + chunkZ, (Throwable)e);
            MinecraftServer.getExceptionManager().handleException(e);
        }
        return AsyncUtils.VOID_FUTURE;
    }

    private void saveSectionData(@NotNull Chunk chunk, @NotNull CompoundBinaryTag.Builder chunkData) {
        ListBinaryTag.Builder sections = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
        ListBinaryTag.Builder blockEntities = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
        ArrayList<StringBinaryTag> biomePalette = new ArrayList<StringBinaryTag>();
        int[] biomeIndices = new int[64];
        ArrayList<CompoundBinaryTag> blockPaletteEntries = new ArrayList<CompoundBinaryTag>();
        IntArrayList blockPaletteIndices = new IntArrayList();
        int[] blockIndices = new int[4096];
        for (int sectionY = chunk.getMinSection(); sectionY < chunk.getMaxSection(); ++sectionY) {
            byte[] blockLight;
            Section section = chunk.getSection(sectionY);
            CompoundBinaryTag.Builder sectionData = CompoundBinaryTag.builder();
            sectionData.putInt("Y", sectionY);
            byte[] skyLight = section.skyLight().array();
            if (skyLight != null && skyLight.length > 0) {
                sectionData.putByteArray("SkyLight", skyLight);
            }
            if ((blockLight = section.blockLight().array()) != null && blockLight.length > 0) {
                sectionData.putByteArray("BlockLight", blockLight);
            }
            for (int sectionLocalY = 0; sectionLocalY < 16; ++sectionLocalY) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int y = sectionLocalY + sectionY * 16;
                        int blockIndex = x + sectionLocalY * 16 * 16 + z * 16;
                        Block block = chunk.getBlock(x, y, z);
                        short blockStateId = block.stateId();
                        CompoundBinaryTag blockState = this.getBlockState(block);
                        int blockPaletteIndex = blockPaletteIndices.indexOf((int)blockStateId);
                        if (blockPaletteIndex == -1) {
                            blockPaletteIndex = blockPaletteEntries.size();
                            blockPaletteEntries.add(blockState);
                            blockPaletteIndices.add((int)blockStateId);
                        }
                        blockIndices[blockIndex] = blockPaletteIndex;
                        if (x % 4 == 0 && sectionLocalY % 4 == 0 && z % 4 == 0) {
                            int biomeIndex = x / 4 + sectionLocalY / 4 * 4 * 4 + z / 4 * 4;
                            Biome biome = chunk.getBiome(x, y, z);
                            StringBinaryTag biomeName = StringBinaryTag.stringBinaryTag((String)biome.name());
                            int biomePaletteIndex = biomePalette.indexOf(biomeName);
                            if (biomePaletteIndex == -1) {
                                biomePaletteIndex = biomePalette.size();
                                biomePalette.add(biomeName);
                            }
                            biomeIndices[biomeIndex] = biomePaletteIndex;
                        }
                        BlockHandler handler = block.handler();
                        CompoundBinaryTag originalNBT = block.nbt();
                        if (originalNBT == null && handler == null) continue;
                        CompoundBinaryTag.Builder blockEntityTag = CompoundBinaryTag.builder();
                        if (originalNBT != null) {
                            blockEntityTag.put(originalNBT);
                        }
                        if (handler != null) {
                            blockEntityTag.putString("id", handler.getNamespaceId().asString());
                        }
                        blockEntityTag.putInt("x", x + 16 * chunk.getChunkX());
                        blockEntityTag.putInt("y", y);
                        blockEntityTag.putInt("z", z + 16 * chunk.getChunkZ());
                        blockEntityTag.putByte("keepPacked", (byte)0);
                        blockEntities.add((BinaryTag)blockEntityTag.build());
                    }
                }
            }
            CompoundBinaryTag.Builder blockStates = CompoundBinaryTag.builder();
            blockStates.put("palette", (BinaryTag)ListBinaryTag.listBinaryTag((BinaryTagType)BinaryTagTypes.COMPOUND, List.copyOf(blockPaletteEntries)));
            if (blockPaletteEntries.size() > 1) {
                int bitsPerEntry = (int)Math.max(1.0, Math.ceil(Math.log(blockPaletteEntries.size()) / Math.log(2.0)));
                blockStates.putLongArray("data", ArrayUtils.pack(blockIndices, bitsPerEntry));
            }
            sectionData.put("block_states", (BinaryTag)blockStates.build());
            CompoundBinaryTag.Builder biomes = CompoundBinaryTag.builder();
            biomes.put("palette", (BinaryTag)ListBinaryTag.listBinaryTag((BinaryTagType)BinaryTagTypes.STRING, List.copyOf(biomePalette)));
            if (biomePalette.size() > 1) {
                int bitsPerEntry = (int)Math.max(1.0, Math.ceil(Math.log(biomePalette.size()) / Math.log(2.0)));
                biomes.putLongArray("data", ArrayUtils.pack(biomeIndices, bitsPerEntry));
            }
            sectionData.put("biomes", (BinaryTag)biomes.build());
            biomePalette.clear();
            blockPaletteEntries.clear();
            blockPaletteIndices.clear();
            sections.add((BinaryTag)sectionData.build());
        }
        chunkData.put("sections", (BinaryTag)sections.build());
        chunkData.put("block_entities", (BinaryTag)blockEntities.build());
    }

    private CompoundBinaryTag getBlockState(Block block) {
        return (CompoundBinaryTag)this.blockStateId2ObjectCacheTLS.get().computeIfAbsent((int)block.stateId(), _unused -> {
            CompoundBinaryTag.Builder tag = CompoundBinaryTag.builder();
            tag.putString("Name", block.name());
            if (!block.properties().isEmpty()) {
                Map<String, String> defaultProperties = Block.fromBlockId(block.id()).properties();
                CompoundBinaryTag.Builder propertiesTag = CompoundBinaryTag.builder();
                for (Map.Entry<String, String> entry : block.properties().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (defaultProperties.get(key).equals(value)) continue;
                    propertiesTag.putString(key, value);
                }
                CompoundBinaryTag properties = propertiesTag.build();
                if (properties.size() > 0) {
                    tag.put("Properties", (BinaryTag)properties);
                }
            }
            return tag.build();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadChunk(Chunk chunk) {
        int regionX = ChunkUtils.toRegionCoordinate(chunk.getChunkX());
        int regionZ = ChunkUtils.toRegionCoordinate(chunk.getChunkZ());
        IntIntImmutablePair regionKey = new IntIntImmutablePair(regionX, regionZ);
        this.perRegionLoadedChunksLock.lock();
        try {
            Set chunks = (Set)this.perRegionLoadedChunks.get(regionKey);
            if (chunks != null) {
                chunks.remove(new IntIntImmutablePair(chunk.getChunkX(), chunk.getChunkZ()));
                if (chunks.isEmpty()) {
                    this.perRegionLoadedChunks.remove(regionKey);
                    RegionFile regionFile = this.alreadyLoaded.remove(RegionFile.getFileName(regionX, regionZ));
                    if (regionFile != null) {
                        try {
                            regionFile.close();
                        }
                        catch (IOException e) {
                            MinecraftServer.getExceptionManager().handleException(e);
                        }
                    }
                }
            }
        }
        finally {
            this.perRegionLoadedChunksLock.unlock();
        }
    }

    @Override
    public boolean supportsParallelLoading() {
        return true;
    }

    @Override
    public boolean supportsParallelSaving() {
        return true;
    }

    private static /* synthetic */ int lambda$loadSections$2(Biome[] convertedPalette, int[] biomeIndices, int x, int y, int z) {
        int index = x + z * 4 + y * 16;
        Biome biome = convertedPalette[biomeIndices[index]];
        return BIOME_MANAGER.getId(biome);
    }

    private static class RegionCache
    extends ConcurrentHashMap<IntIntImmutablePair, Set<IntIntImmutablePair>> {
        private RegionCache() {
        }
    }
}

