/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryClickEvent;
import net.minestom.server.event.inventory.InventoryPostClickEvent;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.InventoryImpl;
import net.minestom.server.inventory.InventoryProperty;
import net.minestom.server.inventory.InventoryType;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.inventory.click.ClickProcessors;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.OpenWindowPacket;
import net.minestom.server.network.packet.server.play.WindowPropertyPacket;
import net.minestom.server.utils.inventory.ClickUtils;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class ContainerInventory
extends InventoryImpl {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private final byte id = ContainerInventory.generateId();
    private final InventoryType inventoryType;
    private Component title;

    @Nullable
    public static List<Click.Change> handleClick(@NotNull Inventory inventory, @NotNull Player player, @NotNull Click.Info info, @NotNull ClickProcessors.InventoryProcessor processor) {
        PlayerInventory playerInventory = player.getInventory();
        InventoryPreClickEvent preClickEvent = new InventoryPreClickEvent(playerInventory, inventory, player, info);
        EventDispatcher.call(preClickEvent);
        if (preClickEvent.isCancelled()) {
            return null;
        }
        Click.Info newInfo = preClickEvent.getClickInfo();
        List changes = (List)processor.apply(newInfo, ClickUtils.makeGetter(inventory, playerInventory));
        InventoryClickEvent clickEvent = new InventoryClickEvent(playerInventory, inventory, player, newInfo, changes);
        EventDispatcher.call(clickEvent);
        if (clickEvent.isCancelled()) {
            return null;
        }
        List<Click.Change> newChanges = clickEvent.getChanges();
        ContainerInventory.apply(newChanges, player, inventory);
        EventDispatcher.call(new InventoryPostClickEvent(player, inventory, newInfo, newChanges));
        return newChanges;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void apply(@NotNull List<Click.Change> changes, @NotNull Player player, @NotNull Inventory inventory) {
        PlayerInventory playerInventory = player.getInventory();
        Iterator<Click.Change> iterator = changes.iterator();
        block11: while (iterator.hasNext()) {
            Object object;
            Click.Change change;
            Click.Change change2 = iterator.next();
            Objects.requireNonNull(change2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Click.Change.Container.class, Click.Change.Player.class, Click.Change.Cursor.class, Click.Change.DropFromPlayer.class}, (Object)change, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ItemStack item;
                    int slot;
                    Click.Change.Container container = (Click.Change.Container)change;
                    try {
                        ItemStack itemStack;
                        int n2;
                        slot = n2 = container.slot();
                        item = itemStack = container.item();
                        if (slot < inventory.getSize()) {
                            inventory.setItemStack(slot, item);
                            continue block11;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    int converted = PlayerInventoryUtils.protocolToMinestom(slot, inventory.getSize());
                    playerInventory.setItemStack(converted, item);
                    continue block11;
                }
                case 1: {
                    Object object2;
                    Click.Change.Player player2 = (Click.Change.Player)change;
                    {
                        int n3;
                        int slot = n3 = player2.slot();
                        Object item = object2 = player2.item();
                        playerInventory.setItemStack(slot, (ItemStack)item);
                        continue block11;
                    }
                }
                case 2: {
                    Object object2 = (Click.Change.Cursor)change;
                    {
                        Object item = object = ((Click.Change.Cursor)object2).item();
                        playerInventory.setCursorItem((ItemStack)item);
                        continue block11;
                    }
                }
                case 3: 
            }
            object = (Click.Change.DropFromPlayer)change;
            {
                ItemStack itemStack;
                ItemStack item = itemStack = ((Click.Change.DropFromPlayer)object).item();
                player.dropItem(item);
            }
        }
        return;
    }

    public ContainerInventory(@NotNull InventoryType inventoryType, @NotNull Component title) {
        super(inventoryType.getSize());
        this.inventoryType = inventoryType;
        this.title = title;
    }

    public ContainerInventory(@NotNull InventoryType inventoryType, @NotNull String title) {
        this(inventoryType, (Component)Component.text((String)title));
    }

    private static byte generateId() {
        return (byte)ID_COUNTER.updateAndGet(i -> i + 1 >= 128 ? 1 : i + 1);
    }

    @NotNull
    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull Component title) {
        this.title = title;
        this.sendPacketToViewers(new OpenWindowPacket(this.getWindowId(), this.getInventoryType().getWindowType(), title));
        this.update();
    }

    @Override
    @Nullable
    public List<Click.Change> handleClick(@NotNull Player player,  @NotNull Click.Info info, @Nullable List<Click.Change> clientPrediction) {
        List<Click.Change> changes = clientPrediction != null && (ClickUtils.conservative(clientPrediction, this, player.getInventory()) || player.isCreative()) ? ContainerInventory.handleClick(this, player, info, (i, g) -> clientPrediction) : ContainerInventory.handleClick(this, player, info, ClickProcessors.PROCESSORS_MAP.getOrDefault((Object)this.inventoryType, ClickProcessors.GENERIC_PROCESSOR));
        if (changes == null || !changes.equals(clientPrediction)) {
            this.update(player);
            player.getInventory().update(player);
        }
        return changes;
    }

    @Override
    public byte getWindowId() {
        return this.id;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        if (!this.viewers.add(player)) {
            return false;
        }
        player.sendPacket(new OpenWindowPacket(this.getWindowId(), this.inventoryType.getWindowType(), this.getTitle()));
        this.update(player);
        return true;
    }

    protected void sendProperty(@NotNull InventoryProperty property, short value) {
        this.sendPacketToViewers(new WindowPropertyPacket(this.getWindowId(), property.getProperty(), value));
    }
}

