/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryItemChangeEvent;
import net.minestom.server.inventory.ContainerInventory;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.TransactionOption;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.CloseWindowPacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

abstract sealed class InventoryImpl
implements Inventory
permits ContainerInventory, PlayerInventory {
    private static final VarHandle ITEM_UPDATER = MethodHandles.arrayElementVarHandle(ItemStack[].class);
    private final int size;
    protected final ItemStack[] itemStacks;
    private final TagHandler tagHandler = TagHandler.newHandler();
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Set<Player> viewers = new CopyOnWriteArraySet<Player>();
    protected final Set<Player> unmodifiableViewers = Collections.unmodifiableSet(this.viewers);

    protected InventoryImpl(int size) {
        this.size = size;
        this.itemStacks = new ItemStack[size];
        Arrays.fill(this.itemStacks, ItemStack.AIR);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public TagHandler tagHandler() {
        return this.tagHandler;
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.unmodifiableViewers;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        if (!this.viewers.add(player)) {
            return false;
        }
        this.update(player);
        return true;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        if (!this.viewers.remove(player)) {
            return false;
        }
        ItemStack cursorItem = player.getInventory().getCursorItem();
        player.getInventory().setCursorItem(ItemStack.AIR);
        if (!cursorItem.isAir() && !player.getInventory().addItemStack(cursorItem)) {
            player.dropItem(cursorItem);
        }
        player.clickPreprocessor().clearCache();
        if (player.skipClosePacket()) {
            player.UNSAFE_changeSkipClosePacket(false);
        } else {
            player.sendPacket(new CloseWindowPacket(this.getWindowId()));
        }
        return true;
    }

    protected void updateSlot(int slot, @NotNull ItemStack itemStack) {
        this.sendPacketToViewers(new SetSlotPacket(this.getWindowId(), 0, (short)slot, itemStack));
    }

    @Override
    public void update() {
        this.viewers.forEach(this::update);
    }

    @Override
    public void update(@NotNull Player player) {
        player.sendPacket(new WindowItemsPacket(this.getWindowId(), 0, List.of(this.itemStacks), player.getInventory().getCursorItem()));
    }

    @Override
    @NotNull
    public ItemStack getItemStack(int slot) {
        return ITEM_UPDATER.getVolatile(this.itemStacks, slot);
    }

    @Override
    @NotNull
    public ItemStack[] getItemStacks() {
        return (ItemStack[])this.itemStacks.clone();
    }

    @Override
    public void copyContents(@NotNull ItemStack[] itemStacks) {
        Check.argCondition(itemStacks.length != this.getSize(), "The size of the array has to be of the same size as the inventory: " + this.getSize());
        for (int i = 0; i < itemStacks.length; ++i) {
            ItemStack itemStack = itemStacks[i];
            Check.notNull(itemStack, "The item array cannot contain any null element!");
            this.setItemStack(i, itemStack);
        }
    }

    @Override
    public void setItemStack(int slot, @NotNull ItemStack itemStack) {
        Check.argCondition(!MathUtils.isBetween(slot, 0, this.getSize()), "Inventory does not have the slot " + slot);
        this.safeItemInsert(slot, itemStack);
    }

    protected final void safeItemInsert(int slot, @NotNull ItemStack itemStack) {
        this.safeItemInsert(slot, itemStack, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void safeItemInsert(int slot, @NotNull ItemStack itemStack, boolean sendPacket) {
        this.lock.lock();
        try {
            ItemStack previous = this.itemStacks[slot];
            if (itemStack.equals(previous)) {
                return;
            }
            this.UNSAFE_itemInsert(slot, itemStack);
            if (sendPacket) {
                this.updateSlot(slot, itemStack);
            }
            EventDispatcher.call(new InventoryItemChangeEvent(this, slot, previous, itemStack));
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void UNSAFE_itemInsert(int slot, @NotNull ItemStack itemStack) {
        this.itemStacks[slot] = itemStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceItemStack(int slot, @NotNull @NotNull UnaryOperator<@NotNull ItemStack> operator) {
        this.lock.lock();
        try {
            ItemStack currentItem = this.getItemStack(slot);
            this.setItemStack(slot, (ItemStack)operator.apply(currentItem));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            for (Player viewer : this.getViewers()) {
                viewer.getInventory().setCursorItem(ItemStack.AIR, false);
            }
            for (int i = 0; i < this.size; ++i) {
                this.safeItemInsert(i, ItemStack.AIR, false);
            }
            this.update();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> T processItemStack(@NotNull ItemStack itemStack, @NotNull TransactionType type, @NotNull TransactionOption<T> option) {
        this.lock.lock();
        try {
            T t = option.fill(type, this, itemStack);
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> @NotNull List<@NotNull T> processItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionType type, @NotNull TransactionOption<T> option) {
        ArrayList<T> result = new ArrayList<T>(itemStacks.size());
        this.lock.lock();
        try {
            for (ItemStack item : itemStacks) {
                result.add(this.processItemStack(item, type, option));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    @NotNull
    public <T> T addItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        List<Integer> slots = IntStream.range(0, this.getSize()).boxed().toList();
        return this.processItemStack(itemStack, TransactionType.add(slots, slots), option);
    }

    @Override
    public boolean addItemStack(@NotNull ItemStack itemStack) {
        return this.addItemStack(itemStack, TransactionOption.ALL_OR_NOTHING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> @NotNull List<@NotNull T> addItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionOption<T> option) {
        ArrayList<T> result = new ArrayList<T>(itemStacks.size());
        this.lock.lock();
        try {
            for (ItemStack item : itemStacks) {
                result.add(this.addItemStack(item, option));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    @NotNull
    public <T> T takeItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        return this.processItemStack(itemStack, TransactionType.take(IntStream.range(0, this.getSize()).boxed().toList()), option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> @NotNull List<@NotNull T> takeItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionOption<T> option) {
        ArrayList<T> result = new ArrayList<T>(itemStacks.size());
        this.lock.lock();
        try {
            for (ItemStack item : itemStacks) {
                result.add(this.takeItemStack(item, option));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }
}

