/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.EntityEquipEvent;
import net.minestom.server.inventory.ContainerInventory;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.InventoryImpl;
import net.minestom.server.inventory.TransactionOption;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.inventory.click.ClickProcessors;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.utils.inventory.ClickUtils;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class PlayerInventory
extends InventoryImpl {
    private static final List<Integer> FILL_ADD_SLOTS = IntStream.concat(IntStream.of(45), IntStream.range(0, 36)).boxed().toList();
    private static final List<Integer> AIR_ADD_SLOTS = IntStream.range(0, 36).boxed().toList();
    private static final List<Integer> TAKE_SLOTS = Stream.of(IntStream.range(0, 36), IntStream.of(45), IntStream.range(36, 45)).flatMapToInt(i -> i).boxed().toList();
    private ItemStack cursorItem = ItemStack.AIR;

    private static int getSlotIndex(@NotNull EquipmentSlot slot, int heldSlot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.HELMET, EquipmentSlot.CHESTPLATE, EquipmentSlot.LEGGINGS, EquipmentSlot.BOOTS -> slot.armorSlot();
            case EquipmentSlot.OFF_HAND -> 45;
            case EquipmentSlot.MAIN_HAND -> heldSlot;
        };
    }

    @Nullable
    private static EquipmentSlot fromSlotIndex(int slot, int heldSlot) {
        return switch (slot) {
            case 41 -> EquipmentSlot.HELMET;
            case 42 -> EquipmentSlot.CHESTPLATE;
            case 43 -> EquipmentSlot.LEGGINGS;
            case 44 -> EquipmentSlot.BOOTS;
            case 45 -> EquipmentSlot.OFF_HAND;
            default -> slot == heldSlot ? EquipmentSlot.MAIN_HAND : null;
        };
    }

    public PlayerInventory() {
        super(46);
    }

    @Override
    public byte getWindowId() {
        return 0;
    }

    @NotNull
    public ItemStack getCursorItem() {
        return this.cursorItem;
    }

    public void setCursorItem(@NotNull ItemStack cursorItem) {
        this.setCursorItem(cursorItem, true);
    }

    public void setCursorItem(@NotNull ItemStack cursorItem, boolean sendPacket) {
        if (this.cursorItem.equals(cursorItem)) {
            return;
        }
        this.lock.lock();
        try {
            this.cursorItem = cursorItem;
        }
        finally {
            this.lock.unlock();
        }
        if (sendPacket) {
            this.sendPacketToViewers(SetSlotPacket.createCursorPacket(cursorItem));
        }
    }

    @Override
    public void updateSlot(int slot, @NotNull ItemStack itemStack) {
        SetSlotPacket defaultPacket = new SetSlotPacket(this.getWindowId(), 0, (short)PlayerInventoryUtils.minestomToProtocol(slot), itemStack);
        for (Player player : this.getViewers()) {
            Inventory open = player.getOpenInventory();
            if (open != null && slot >= 0 && slot < 36) {
                player.sendPacket(new SetSlotPacket(open.getWindowId(), 0, (short)PlayerInventoryUtils.minestomToProtocol(slot, open.getSize()), itemStack));
            } else if (open == null || slot == 45) {
                player.sendPacket(defaultPacket);
            }
            EquipmentSlot equipmentSlot = PlayerInventory.fromSlotIndex(slot, player.getHeldSlot());
            if (equipmentSlot == null) continue;
            player.syncEquipment(equipmentSlot, itemStack);
        }
    }

    @Override
    public void update(@NotNull Player player) {
        ItemStack[] local = this.getItemStacks();
        ItemStack[] mapped = new ItemStack[this.getSize()];
        for (int slot = 0; slot < this.getSize(); ++slot) {
            mapped[PlayerInventoryUtils.minestomToProtocol((int)slot)] = local[slot];
        }
        player.sendPacket(new WindowItemsPacket(this.getWindowId(), 0, List.of(mapped), this.getCursorItem()));
    }

    @Override
    protected void UNSAFE_itemInsert(int slot, @NotNull ItemStack itemStack) {
        for (Player player : this.getViewers()) {
            EquipmentSlot equipmentSlot = PlayerInventory.fromSlotIndex(slot, player.getHeldSlot());
            if (equipmentSlot == null) continue;
            EntityEquipEvent entityEquipEvent = new EntityEquipEvent(player, itemStack, equipmentSlot);
            EventDispatcher.call(entityEquipEvent);
            itemStack = entityEquipEvent.getEquippedItem();
        }
        super.UNSAFE_itemInsert(slot, itemStack);
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
            for (Player player : this.getViewers()) {
                player.sendPacketToViewersAndSelf(player.getEquipmentsPacket());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public List<Click.Change> handleClick(@NotNull Player player,  @NotNull Click.Info info, @Nullable List<Click.Change> clientPrediction) {
        List<Click.Change> changes = clientPrediction != null && (ClickUtils.conservative(clientPrediction, this, this) || player.isCreative()) ? ContainerInventory.handleClick(this, player, info, (i, g) -> clientPrediction) : ContainerInventory.handleClick(this, player, info, ClickProcessors.PLAYER_PROCESSOR);
        if (changes == null || !changes.equals(clientPrediction)) {
            this.update(player);
        }
        return changes;
    }

    @NotNull
    public ItemStack getEquipment(@NotNull EquipmentSlot slot, int heldSlot) {
        return this.getItemStack(PlayerInventory.getSlotIndex(slot, heldSlot));
    }

    public void setEquipment(@NotNull EquipmentSlot slot, int heldSlot, @NotNull ItemStack newValue) {
        this.setItemStack(PlayerInventory.getSlotIndex(slot, heldSlot), newValue);
    }

    @Override
    @NotNull
    public <T> T addItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        return (T)this.processItemStack(itemStack, TransactionType.add(FILL_ADD_SLOTS, AIR_ADD_SLOTS), (TransactionOption)option);
    }

    @Override
    @NotNull
    public <T> T takeItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        return (T)this.processItemStack(itemStack, TransactionType.take(TAKE_SLOTS), (TransactionOption)option);
    }
}

