/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface TransactionOperator
extends UnaryOperator<Entry> {
    public static final TransactionOperator STACK_LEFT = entry -> {
        int rightAmount;
        ItemStack left = entry.left();
        ItemStack right = entry.right();
        if (right.isAir() || !left.isAir() && (!left.isSimilar(right) || left.amount() >= left.maxStackSize())) {
            return null;
        }
        int leftAmount = left.isAir() ? 0 : left.amount();
        int addedAmount = rightAmount = right.amount();
        if (!left.isAir()) {
            addedAmount = Math.min(rightAmount, left.maxStackSize() - leftAmount);
        }
        return new Entry((left.isAir() ? right : left).withAmount(leftAmount + addedAmount), right.withAmount(rightAmount - addedAmount));
    };
    public static final TransactionOperator STACK_RIGHT = TransactionOperator.flip(STACK_LEFT);
    public static final TransactionOperator TAKE = entry -> {
        ItemStack left = entry.left();
        ItemStack right = entry.right();
        if (right.isAir() || !left.isSimilar(right)) {
            return null;
        }
        int leftAmount = left.amount();
        int rightAmount = right.amount();
        int subtracted = Math.min(leftAmount, rightAmount);
        return new Entry(left.withAmount(leftAmount - subtracted), right.withAmount(rightAmount - subtracted));
    };

    @NotNull
    public static TransactionOperator filter(@NotNull TransactionOperator operator, @NotNull BiPredicate<ItemStack, ItemStack> predicate) {
        return entry -> {
            ItemStack right;
            ItemStack left = entry.left();
            return predicate.test(left, right = entry.right()) ? (Entry)operator.apply(entry) : null;
        };
    }

    @NotNull
    public static TransactionOperator flip(@NotNull TransactionOperator operator) {
        return entry -> {
            Entry pair = (Entry)operator.apply(entry.reverse());
            return pair != null ? new Entry(pair.right(), pair.left()) : null;
        };
    }

    @NotNull
    public static TransactionOperator stackLeftN(int count) {
        return entry -> {
            ItemStack left = entry.left();
            ItemStack right = entry.right();
            if (right.isAir() || !left.isAir() && (!left.isSimilar(right) || left.amount() >= left.maxStackSize())) {
                return null;
            }
            int leftAmount = left.isAir() ? 0 : left.amount();
            int rightAmount = right.amount();
            int addedAmount = Math.min(rightAmount, count);
            if (!left.isAir()) {
                addedAmount = Math.min(addedAmount, left.maxStackSize() - leftAmount);
            }
            if (addedAmount == 0) {
                return null;
            }
            return new Entry((left.isAir() ? right : left).withAmount(leftAmount + addedAmount), right.withAmount(rightAmount - addedAmount));
        };
    }

    default public Entry apply(@NotNull ItemStack left, @NotNull ItemStack right) {
        return (Entry)this.apply(new Entry(left, right));
    }

    public record Entry(@NotNull ItemStack left, @NotNull ItemStack right) {
        public Entry reverse() {
            return new Entry(this.right, this.left);
        }
    }
}

