/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.Map;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface TransactionOption<T> {
    public static final TransactionOption<ItemStack> ALL = (inventory, result, itemChangesMap) -> {
        itemChangesMap.forEach(inventory::setItemStack);
        return result;
    };
    public static final TransactionOption<Boolean> ALL_OR_NOTHING = (inventory, result, itemChangesMap) -> {
        if (result.isAir()) {
            itemChangesMap.forEach(inventory::setItemStack);
            return true;
        }
        return false;
    };
    public static final TransactionOption<Boolean> DRY_RUN = (inventory, result, itemChangesMap) -> result.isAir();

    @NotNull
    public T fill(@NotNull Inventory var1, @NotNull ItemStack var2, @NotNull Map<Integer, ItemStack> var3);

    @NotNull
    default public T fill(@NotNull TransactionType type, @NotNull Inventory inventory, @NotNull ItemStack itemStack) {
        TransactionType.Entry result = type.apply(itemStack, inventory::getItemStack);
        return this.fill(inventory, result.remaining(), result.changes());
    }
}

