/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import net.minestom.server.inventory.TransactionOperator;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface TransactionType
extends BiFunction<ItemStack, IntFunction<ItemStack>, Entry> {
    @NotNull
    public static TransactionType general(@NotNull TransactionOperator operator, @NotNull List<Integer> slots) {
        return (item, getter) -> {
            Int2ObjectArrayMap map = new Int2ObjectArrayMap();
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                ItemStack slotItem = (ItemStack)getter.apply(slot);
                TransactionOperator.Entry result = operator.apply(slotItem, item);
                if (result == null) continue;
                map.put(slot, (Object)result.left());
                item = result.right();
            }
            return new Entry(item, (Map<Integer, ItemStack>)map);
        };
    }

    @NotNull
    public static TransactionType join(@NotNull TransactionType first, @NotNull TransactionType second) {
        return (item, getter) -> {
            Entry f = first.apply(item, getter);
            Entry s = second.apply(f.remaining(), getter);
            Int2ObjectArrayMap map = new Int2ObjectArrayMap();
            map.putAll(f.changes());
            map.putAll(s.changes());
            return new Entry(s.remaining(), (Map<Integer, ItemStack>)map);
        };
    }

    @NotNull
    public static TransactionType add(@NotNull List<Integer> fill, @NotNull List<Integer> air) {
        TransactionType first = TransactionType.general(entry -> {
            ItemStack slotItem = entry.left();
            ItemStack extra = entry.right();
            return !slotItem.isAir() ? TransactionOperator.STACK_LEFT.apply(slotItem, extra) : null;
        }, fill);
        TransactionType second = TransactionType.general(entry -> {
            ItemStack slotItem = entry.left();
            ItemStack extra = entry.right();
            return slotItem.isAir() ? TransactionOperator.STACK_LEFT.apply(slotItem, extra) : null;
        }, air);
        return TransactionType.join(first, second);
    }

    @NotNull
    public static TransactionType take(@NotNull List<Integer> takeSlots) {
        return TransactionType.general(TransactionOperator.TAKE, takeSlots);
    }

    @Override
    @NotNull
    public Entry apply(@NotNull ItemStack var1, @NotNull IntFunction<ItemStack> var2);

    public record Entry(@NotNull ItemStack remaining, @NotNull @NotNull Map<@NotNull Integer, @NotNull ItemStack> changes) {
        public Entry(@NotNull ItemStack remaining, @NotNull Map<Integer, ItemStack> changes) {
            changes = Map.copyOf(changes);
        }
    }
}

