/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.click;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Click {

    public static sealed interface Change {

        public record DropFromPlayer(@NotNull ItemStack item) implements Change
        {
        }

        public record Cursor(@NotNull ItemStack item) implements Change
        {
        }

        public record Player(int slot, @NotNull ItemStack item) implements Change
        {
        }

        public record Container(int slot, @NotNull ItemStack item) implements Change
        {
        }
    }

    public record Getter(@NotNull IntFunction<ItemStack> main, @NotNull IntFunction<ItemStack> player, @NotNull ItemStack cursor, int mainSize) {
        @NotNull
        public ItemStack get(int slot) {
            if (slot < this.mainSize()) {
                return this.main.apply(slot);
            }
            return this.player.apply(PlayerInventoryUtils.protocolToMinestom(slot, this.mainSize()));
        }
    }

    public static final class Preprocessor {
        private final Set<Integer> leftDrag = new LinkedHashSet<Integer>();
        private final Set<Integer> rightDrag = new LinkedHashSet<Integer>();
        private final Set<Integer> middleDrag = new LinkedHashSet<Integer>();

        public void clearCache() {
            this.leftDrag.clear();
            this.rightDrag.clear();
            this.middleDrag.clear();
        }

        @Nullable
        public Info processClick(@NotNull ClientClickWindowPacket packet, boolean isCreative, @Nullable Integer containerSize) {
            boolean valid;
            boolean requireCreative;
            byte button = packet.button();
            switch (packet.clickType()) {
                case CLONE: {
                    boolean bl;
                    if (packet.slot() != -999) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case QUICK_CRAFT: {
                    boolean bl;
                    if (button == 8 || button == 9 || button == 10) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = requireCreative = false;
                }
            }
            if (requireCreative && !isCreative) {
                return null;
            }
            int slot = packet.slot() == -999 ? -999 : (containerSize == null ? PlayerInventoryUtils.protocolToMinestom(packet.slot()) : (int)packet.slot());
            int maxSize = containerSize != null ? containerSize + 36 : 46;
            boolean bl = valid = slot >= 0 && slot < maxSize;
            if (!valid) {
                return slot == -999 ? this.processInvalidSlot(packet.clickType(), button) : null;
            }
            return this.process(packet.clickType(), slot, button);
        }

        @Nullable
        private Info processInvalidSlot(@NotNull ClientClickWindowPacket.ClickType type, byte button) {
            return switch (type) {
                case ClientClickWindowPacket.ClickType.PICKUP -> {
                    if (button == 0) {
                        yield new Info.LeftDropCursor();
                    }
                    if (button == 1) {
                        yield new Info.RightDropCursor();
                    }
                    yield null;
                }
                case ClientClickWindowPacket.ClickType.CLONE -> {
                    if (button == 2) {
                        yield new Info.MiddleDropCursor();
                    }
                    yield null;
                }
                case ClientClickWindowPacket.ClickType.QUICK_CRAFT -> {
                    if (button == 2) {
                        List<Integer> list = List.copyOf(this.leftDrag);
                        this.leftDrag.clear();
                        yield new Info.LeftDrag(list);
                    }
                    if (button == 6) {
                        List<Integer> list = List.copyOf(this.rightDrag);
                        this.rightDrag.clear();
                        yield new Info.RightDrag(list);
                    }
                    if (button == 10) {
                        List<Integer> list = List.copyOf(this.middleDrag);
                        this.middleDrag.clear();
                        yield new Info.MiddleDrag(list);
                    }
                    if (button == 0) {
                        this.leftDrag.clear();
                    }
                    if (button == 4) {
                        this.rightDrag.clear();
                    }
                    if (button == 8) {
                        this.middleDrag.clear();
                    }
                    yield null;
                }
                default -> null;
            };
        }

        @Nullable
        private Info process(@NotNull ClientClickWindowPacket.ClickType type, int slot, byte button) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ClientClickWindowPacket.ClickType.PICKUP -> {
                    switch (button) {
                        case 0: {
                            yield new Info.Left(slot);
                        }
                        case 1: {
                            yield new Info.Right(slot);
                        }
                    }
                    yield null;
                }
                case ClientClickWindowPacket.ClickType.QUICK_MOVE -> {
                    if (button == 0) {
                        yield new Info.LeftShift(slot);
                    }
                    yield new Info.RightShift(slot);
                }
                case ClientClickWindowPacket.ClickType.SWAP -> {
                    if (button >= 0 && button < 9) {
                        yield new Info.HotbarSwap(button, slot);
                    }
                    if (button == 40) {
                        yield new Info.OffhandSwap(slot);
                    }
                    yield null;
                }
                case ClientClickWindowPacket.ClickType.CLONE -> new Info.Middle(slot);
                case ClientClickWindowPacket.ClickType.THROW -> new Info.DropSlot(slot, button == 1);
                case ClientClickWindowPacket.ClickType.QUICK_CRAFT -> {
                    switch (button) {
                        case 1: {
                            this.leftDrag.add(slot);
                            break;
                        }
                        case 5: {
                            this.rightDrag.add(slot);
                            break;
                        }
                        case 9: {
                            this.middleDrag.add(slot);
                        }
                    }
                    yield null;
                }
                case ClientClickWindowPacket.ClickType.PICKUP_ALL -> new Info.Double(slot);
            };
        }
    }

    public static sealed interface Info {

        public record CreativeDropItem(@NotNull ItemStack item) implements Info
        {
        }

        public record CreativeSetItem(int slot, @NotNull ItemStack item) implements Info
        {
        }

        public record OffhandSwap(int slot) implements Info
        {
        }

        public record HotbarSwap(int hotbarSlot, int clickedSlot) implements Info
        {
        }

        public record DropSlot(int slot, boolean all) implements Info
        {
        }

        public record MiddleDropCursor() implements Info
        {
        }

        public record RightDropCursor() implements Info
        {
        }

        public record LeftDropCursor() implements Info
        {
        }

        public record MiddleDrag(List<Integer> slots) implements Info
        {
            public MiddleDrag {
                slots = List.copyOf(slots);
            }
        }

        public record RightDrag(List<Integer> slots) implements Info
        {
            public RightDrag {
                slots = List.copyOf(slots);
            }
        }

        public record LeftDrag(List<Integer> slots) implements Info
        {
            public LeftDrag {
                slots = List.copyOf(slots);
            }
        }

        public record Double(int slot) implements Info
        {
        }

        public record RightShift(int slot) implements Info
        {
        }

        public record LeftShift(int slot) implements Info
        {
        }

        public record Middle(int slot) implements Info
        {
        }

        public record Right(int slot) implements Info
        {
        }

        public record Left(int slot) implements Info
        {
        }
    }
}

