/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.click;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.inventory.InventoryType;
import net.minestom.server.inventory.TransactionOperator;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;

public final class ClickProcessors {
    public static final InventoryProcessor PLAYER_PROCESSOR = ClickProcessors.standard((getter, item, slot) -> {
        ArrayList<Integer> slots;
        block12: {
            block11: {
                block10: {
                    block9: {
                        slots = new ArrayList<Integer>();
                        EquipmentSlot equipmentSlot = item.material().registry().equipmentSlot();
                        if (equipmentSlot != null && slot != equipmentSlot.armorSlot()) {
                            slots.add(equipmentSlot.armorSlot());
                        }
                        if (item.material() == Material.SHIELD && slot != 45) {
                            slots.add(45);
                        }
                        if (slot < 9) break block9;
                        if (slot <= 35) break block10;
                    }
                    IntStream.range(9, 36).forEach(slots::add);
                }
                if (slot < 0) break block11;
                if (slot <= 8) break block12;
            }
            IntStream.range(0, 9).forEach(slots::add);
        }
        if (slot == 36) {
            Collections.reverse(slots);
        }
        return slots.stream().mapToInt(i -> i);
    }, (getter, item, slot) -> Stream.of(IntStream.range(37, 41), IntStream.range(41, 45), IntStream.range(9, 36), IntStream.range(0, 9), IntStream.of(45)).flatMapToInt(i -> i));
    public static final InventoryProcessor GENERIC_PROCESSOR = ClickProcessors.standard((builder, item, slot) -> {
        int size = builder.mainSize();
        return slot >= size ? IntStream.range(0, size) : PlayerInventoryUtils.getInnerShiftClickSlots(size);
    }, (builder, item, slot) -> {
        int size = builder.mainSize();
        return IntStream.concat(IntStream.range(0, size), PlayerInventoryUtils.getInnerDoubleClickSlots(size));
    });
    public static final InventoryProcessor FURNACE_PROCESSOR = ClickProcessors.standard((builder, item, slot) -> {
        int size = builder.mainSize();
        if (slot < size) {
            return PlayerInventoryUtils.getInnerShiftClickSlots(size);
        }
        if (slot < size + 27) {
            return IntStream.range(27, 36).map(i -> i + size);
        }
        return IntStream.range(0, 27).map(i -> i + size);
    }, (builder, item, slot) -> {
        int size = builder.mainSize();
        return IntStream.concat(IntStream.range(0, size), PlayerInventoryUtils.getInnerDoubleClickSlots(size));
    });
    public static final Map<InventoryType, InventoryProcessor> PROCESSORS_MAP = Map.ofEntries(Map.entry(InventoryType.FURNACE, FURNACE_PROCESSOR));

    @NotNull
    public static List<Click.Change> leftClick(int slot, @NotNull Click.Getter getter) {
        ItemStack cursor = getter.cursor();
        ItemStack clickedItem = getter.get(slot);
        TransactionOperator.Entry pair = TransactionOperator.STACK_LEFT.apply(clickedItem, cursor);
        if (pair != null) {
            return List.of(new Click.Change.Container(slot, pair.left()), new Click.Change.Cursor(pair.right()));
        }
        if (!cursor.isSimilar(clickedItem)) {
            return List.of(new Click.Change.Container(slot, cursor), new Click.Change.Cursor(clickedItem));
        }
        return List.of();
    }

    @NotNull
    public static List<Click.Change> rightClick(int slot, @NotNull Click.Getter getter) {
        ItemStack cursor = getter.cursor();
        ItemStack clickedItem = getter.get(slot);
        if (cursor.isAir() && clickedItem.isAir()) {
            return List.of();
        }
        if (cursor.isAir()) {
            int newAmount = (int)Math.ceil((double)clickedItem.amount() / 2.0);
            TransactionOperator.Entry cursorSlot = TransactionOperator.stackLeftN(newAmount).apply(cursor, clickedItem);
            if (cursorSlot == null) {
                return List.of();
            }
            return List.of(new Click.Change.Container(slot, cursorSlot.right()), new Click.Change.Cursor(cursorSlot.left()));
        }
        if (clickedItem.isAir() || clickedItem.isSimilar(cursor)) {
            TransactionOperator.Entry slotCursor = TransactionOperator.stackLeftN(1).apply(clickedItem, cursor);
            if (slotCursor == null) {
                return List.of();
            }
            return List.of(new Click.Change.Container(slot, slotCursor.left()), new Click.Change.Cursor(slotCursor.right()));
        }
        return List.of(new Click.Change.Cursor(clickedItem), new Click.Change.Container(slot, cursor));
    }

    @NotNull
    public static List<Click.Change> middleClick(int slot, @NotNull Click.Getter getter) {
        ItemStack item = getter.get(slot);
        if (!getter.cursor().isAir() || item.isAir()) {
            return List.of();
        }
        return List.of(new Click.Change.Cursor(item.withAmount(item.maxStackSize())));
    }

    @NotNull
    public static List<Click.Change> shiftClick(int slot, @NotNull List<Integer> slots, @NotNull Click.Getter getter) {
        ItemStack clicked = getter.get(slot);
        slots = new ArrayList<Integer>(slots);
        slots.removeIf(i -> i == slot);
        TransactionType.Entry result = TransactionType.add(slots, slots).apply(clicked, getter::get);
        ArrayList<Click.Change> changes = new ArrayList<Click.Change>();
        result.changes().forEach((slotId, item) -> changes.add(new Click.Change.Container((int)slotId, (ItemStack)item)));
        if (!result.remaining().equals(clicked)) {
            changes.add(new Click.Change.Container(slot, result.remaining()));
        }
        return changes;
    }

    @NotNull
    public static List<Click.Change> doubleClick(@NotNull List<Integer> slots, @NotNull Click.Getter getter) {
        ItemStack cursor = getter.cursor();
        if (cursor.isAir()) {
            return List.of();
        }
        TransactionType unstacked = TransactionType.general(TransactionOperator.filter(TransactionOperator.STACK_RIGHT, (left, right) -> left.amount() < left.maxStackSize()), slots);
        TransactionType stacked = TransactionType.general(TransactionOperator.filter(TransactionOperator.STACK_RIGHT, (left, right) -> left.amount() == left.maxStackSize()), slots);
        TransactionType.Entry result = TransactionType.join(unstacked, stacked).apply(cursor, getter::get);
        ArrayList<Click.Change> changes = new ArrayList<Click.Change>();
        result.changes().forEach((slotId, item) -> changes.add(new Click.Change.Container((int)slotId, (ItemStack)item)));
        if (!result.remaining().equals(cursor)) {
            changes.add(new Click.Change.Cursor(result.remaining()));
        }
        return changes;
    }

    @NotNull
    public static List<Click.Change> dragClick(int countPerSlot, @NotNull List<Integer> slots, @NotNull Click.Getter getter) {
        ItemStack cursor = getter.cursor();
        if (cursor.isAir()) {
            return List.of();
        }
        TransactionType.Entry result = TransactionType.general(TransactionOperator.stackLeftN(countPerSlot), slots).apply(cursor, getter::get);
        ArrayList<Click.Change> changes = new ArrayList<Click.Change>();
        result.changes().forEach((slotId, item) -> changes.add(new Click.Change.Container((int)slotId, (ItemStack)item)));
        if (!result.remaining().equals(cursor)) {
            changes.add(new Click.Change.Cursor(result.remaining()));
        }
        return changes;
    }

    @NotNull
    public static List<Click.Change> middleDragClick(@NotNull List<Integer> slots, @NotNull Click.Getter getter) {
        ItemStack cursor = getter.cursor();
        return slots.stream().filter(slot -> getter.get((int)slot).isAir()).map(slot -> new Click.Change.Container((int)slot, cursor)).toList();
    }

    @NotNull
    public static List<Click.Change> dropFromCursor(int amount, @NotNull Click.Getter getter) {
        ItemStack cursor = getter.cursor();
        if (cursor.isAir()) {
            return List.of();
        }
        TransactionOperator.Entry pair = TransactionOperator.stackLeftN(amount).apply(ItemStack.AIR, cursor);
        if (pair == null) {
            return List.of();
        }
        return List.of(new Click.Change.Cursor(pair.right()), new Click.Change.DropFromPlayer(pair.left()));
    }

    @NotNull
    public static List<Click.Change> dropFromSlot(int slot, int amount, @NotNull Click.Getter getter) {
        ItemStack item = getter.get(slot);
        if (item.isAir()) {
            return List.of();
        }
        TransactionOperator.Entry pair = TransactionOperator.stackLeftN(amount).apply(ItemStack.AIR, item);
        if (pair == null) {
            return List.of();
        }
        return List.of(new Click.Change.Container(slot, pair.right()), new Click.Change.DropFromPlayer(pair.left()));
    }

    public static @NotNull InventoryProcessor standard(@NotNull SlotSuggestor shiftClickSlots, @NotNull SlotSuggestor doubleClickSlots) {
        return (info, getter) -> {
            ItemStack item;
            List<Object> list;
            Click.Info info2 = info;
            Objects.requireNonNull(info2);
            Click.Info selector17$temp = info2;
            int index$18 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Click.Info.Left.class, Click.Info.Right.class, Click.Info.Middle.class, Click.Info.LeftShift.class, Click.Info.RightShift.class, Click.Info.Double.class, Click.Info.LeftDrag.class, Click.Info.RightDrag.class, Click.Info.MiddleDrag.class, Click.Info.DropSlot.class, Click.Info.LeftDropCursor.class, Click.Info.RightDropCursor.class, Click.Info.MiddleDropCursor.class, Click.Info.HotbarSwap.class, Click.Info.OffhandSwap.class, Click.Info.CreativeSetItem.class, Click.Info.CreativeDropItem.class}, (Object)selector17$temp, index$18)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    int slot;
                    Click.Info.Left $b$0 = (Click.Info.Left)selector17$temp;
                    try {
                        int patt19$temp;
                        slot = patt19$temp = $b$0.slot();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    list = ClickProcessors.leftClick(slot, getter);
                    return list;
                }
                case 1: {
                    int slot;
                    Click.Info.Right $b$1 = (Click.Info.Right)selector17$temp;
                    {
                        int patt20$temp;
                        slot = patt20$temp = $b$1.slot();
                    }
                    list = ClickProcessors.rightClick(slot, getter);
                    return list;
                }
                case 2: {
                    int slot;
                    Click.Info.Middle $b$2 = (Click.Info.Middle)selector17$temp;
                    {
                        int patt21$temp;
                        slot = patt21$temp = $b$2.slot();
                    }
                    list = ClickProcessors.middleClick(slot, getter);
                    return list;
                }
                case 3: {
                    int slot;
                    Click.Info.LeftShift $b$3 = (Click.Info.LeftShift)selector17$temp;
                    {
                        int patt22$temp;
                        slot = patt22$temp = $b$3.slot();
                    }
                    list = ClickProcessors.shiftClick(slot, shiftClickSlots.getList((Click.Getter)getter, getter.get(slot), slot), getter);
                    return list;
                }
                case 4: {
                    int slot;
                    Click.Info.RightShift $b$4 = (Click.Info.RightShift)selector17$temp;
                    {
                        int patt23$temp;
                        slot = patt23$temp = $b$4.slot();
                    }
                    list = ClickProcessors.shiftClick(slot, shiftClickSlots.getList((Click.Getter)getter, getter.get(slot), slot), getter);
                    return list;
                }
                case 5: {
                    int slot;
                    Click.Info.Double $b$5 = (Click.Info.Double)selector17$temp;
                    {
                        int patt24$temp;
                        slot = patt24$temp = $b$5.slot();
                    }
                    list = ClickProcessors.doubleClick(doubleClickSlots.getList((Click.Getter)getter, getter.get(slot), slot), getter);
                    return list;
                }
                case 6: {
                    int cursorAmount;
                    List<Integer> slots;
                    Click.Info.LeftDrag $b$6 = (Click.Info.LeftDrag)selector17$temp;
                    {
                        List<Integer> patt25$temp;
                        slots = patt25$temp = $b$6.slots();
                        cursorAmount = getter.cursor().amount();
                    }
                    int amount = (int)Math.floor((double)cursorAmount / (double)slots.size());
                    list = ClickProcessors.dragClick(amount, slots, getter);
                    return list;
                }
                case 7: {
                    List<Integer> slots;
                    Click.Info.RightDrag $b$7 = (Click.Info.RightDrag)selector17$temp;
                    {
                        List<Integer> patt26$temp;
                        slots = patt26$temp = $b$7.slots();
                    }
                    list = ClickProcessors.dragClick(1, slots, getter);
                    return list;
                }
                case 8: {
                    List<Integer> slots;
                    Click.Info.MiddleDrag $b$8 = (Click.Info.MiddleDrag)selector17$temp;
                    {
                        List<Integer> patt27$temp;
                        slots = patt27$temp = $b$8.slots();
                    }
                    list = ClickProcessors.middleDragClick(slots, getter);
                    return list;
                }
                case 9: {
                    Click.Info.DropSlot $b$9 = (Click.Info.DropSlot)selector17$temp;
                    {
                        boolean patt29$temp;
                        int patt28$temp;
                        int slot = patt28$temp = $b$9.slot();
                        boolean all = patt29$temp = $b$9.all();
                        list = ClickProcessors.dropFromSlot(slot, all ? getter.get(slot).amount() : 1, getter);
                    }
                    return list;
                }
                case 10: {
                    Click.Info.LeftDropCursor $b$10 = (Click.Info.LeftDropCursor)selector17$temp;
                    list = ClickProcessors.dropFromCursor(getter.cursor().amount(), getter);
                    return list;
                }
                case 11: {
                    Click.Info.RightDropCursor $b$11 = (Click.Info.RightDropCursor)selector17$temp;
                    list = ClickProcessors.dropFromCursor(1, getter);
                    return list;
                }
                case 12: {
                    Click.Info.MiddleDropCursor $b$12 = (Click.Info.MiddleDropCursor)selector17$temp;
                    list = List.of();
                    return list;
                }
                case 13: {
                    ItemStack selectedItem;
                    ItemStack hotbarItem;
                    int clickedSlot;
                    int hotbarSlot;
                    Click.Info.HotbarSwap $b$13 = (Click.Info.HotbarSwap)selector17$temp;
                    {
                        int patt31$temp;
                        int patt30$temp;
                        hotbarSlot = patt30$temp = $b$13.hotbarSlot();
                        clickedSlot = patt31$temp = $b$13.clickedSlot();
                        hotbarItem = getter.player().apply(hotbarSlot);
                        selectedItem = getter.get(clickedSlot);
                    }
                    if (hotbarItem.equals(selectedItem)) {
                        list = List.of();
                        return list;
                    }
                    list = List.of(new Click.Change.Container(clickedSlot, hotbarItem), new Click.Change.Player(hotbarSlot, selectedItem));
                    return list;
                }
                case 14: {
                    ItemStack selectedItem;
                    ItemStack offhandItem;
                    int slot;
                    Click.Info.OffhandSwap $b$14 = (Click.Info.OffhandSwap)selector17$temp;
                    {
                        int patt32$temp;
                        slot = patt32$temp = $b$14.slot();
                        offhandItem = getter.player().apply(45);
                        selectedItem = getter.get(slot);
                    }
                    if (offhandItem.equals(selectedItem)) {
                        list = List.of();
                        return list;
                    }
                    list = List.of(new Click.Change.Container(slot, offhandItem), new Click.Change.Player(45, selectedItem));
                    return list;
                }
                case 15: {
                    ItemStack item2;
                    int slot;
                    Click.Info.CreativeSetItem $b$15 = (Click.Info.CreativeSetItem)selector17$temp;
                    {
                        ItemStack patt34$temp;
                        int patt33$temp;
                        slot = patt33$temp = $b$15.slot();
                        item2 = patt34$temp = $b$15.item();
                    }
                    list = List.of(new Click.Change.Container(slot, item2));
                    return list;
                }
                case 16: 
            }
            Click.Info.CreativeDropItem $b$16 = (Click.Info.CreativeDropItem)selector17$temp;
            {
                ItemStack patt35$temp;
                item = patt35$temp = $b$16.item();
            }
            list = List.of(new Click.Change.DropFromPlayer(item));
            return list;
        };
    }

    @FunctionalInterface
    public static interface SlotSuggestor {
        @NotNull
        public IntStream get(@NotNull Click.Getter var1, @NotNull ItemStack var2, int var3);

        @NotNull
        default public List<Integer> getList(@NotNull Click.Getter builder, @NotNull ItemStack item, int slot) {
            return this.get(builder, item, slot).boxed().toList();
        }
    }

    public static interface InventoryProcessor
    extends BiFunction<Click.Info, Click.Getter, List<Click.Change>> {
    }
}

