/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponentPatch;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStackImpl;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.CustomData;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagWritable;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface ItemStack
extends TagReadable,
DataComponentMap,
HoverEventSource<HoverEvent.ShowItem>
permits ItemStackImpl {
    @NotNull
    public static final ItemStack AIR = ItemStack.of(Material.AIR);
    @NotNull
    public static final NetworkBuffer.Type<ItemStack> NETWORK_TYPE = ItemStackImpl.NETWORK_TYPE;
    @NotNull
    public static final NetworkBuffer.Type<ItemStack> STRICT_NETWORK_TYPE = ItemStackImpl.STRICT_NETWORK_TYPE;
    @NotNull
    public static final BinaryTagSerializer<ItemStack> NBT_TYPE = ItemStackImpl.NBT_TYPE;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Builder builder(@NotNull Material material) {
        return new ItemStackImpl.Builder(material, 1);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material) {
        return ItemStack.of(material, 1);
    }

    @Contract(value="_ ,_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material, int amount) {
        return ItemStackImpl.create(material, amount);
    }

    @Contract(value="_ ,_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material, @NotNull DataComponentMap components) {
        return ItemStackImpl.create(material, 1, DataComponentPatch.from(material.registry().prototype(), components));
    }

    @Contract(value="_ ,_, _ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material, int amount, @NotNull DataComponentMap components) {
        return ItemStackImpl.create(material, amount, DataComponentPatch.from(material.registry().prototype(), components));
    }

    @NotNull
    public static ItemStack fromItemNBT(@NotNull CompoundBinaryTag nbtCompound) {
        return NBT_TYPE.read((BinaryTag)nbtCompound);
    }

    @Contract(pure=true)
    @NotNull
    public Material material();

    @Contract(pure=true)
    public int amount();

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack with(@NotNull @NotNull Consumer<@NotNull Builder> var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack withMaterial(@NotNull Material var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack withAmount(int var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withAmount(@NotNull IntUnaryOperator intUnaryOperator) {
        return this.withAmount(intUnaryOperator.applyAsInt(this.amount()));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public <T> ItemStack with(@NotNull DataComponent<T> var1, T var2);

    @NotNull
    default public <T> ItemStack with(@NotNull DataComponent<T> component, @NotNull UnaryOperator<T> operator) {
        T value = this.get(component);
        if (value == null) {
            return this;
        }
        return this.with(component, operator.apply(value));
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack without(@NotNull DataComponent<?> var1);

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    default public <T> ItemStack withTag(@NotNull Tag<T> tag, @Nullable T value) {
        return this.with(ItemComponent.CUSTOM_DATA, this.get(ItemComponent.CUSTOM_DATA, CustomData.EMPTY).withTag(tag, value));
    }

    @Override
    @Contract(pure=true)
    default public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.get(ItemComponent.CUSTOM_DATA, CustomData.EMPTY).getTag(tag);
    }

    @Contract(pure=true)
    default public int maxStackSize() {
        return this.get(ItemComponent.MAX_STACK_SIZE, 64);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack consume(int var1);

    @Contract(pure=true)
    default public boolean isAir() {
        return this.material() == Material.AIR;
    }

    @Contract(pure=true)
    public boolean isSimilar(@NotNull ItemStack var1);

    @NotNull
    public CompoundBinaryTag toItemNBT();

    @NotNull
    default public HoverEvent<HoverEvent.ShowItem> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowItem> op) {
        try {
            BinaryTagHolder tagHolder = BinaryTagHolder.encode((Object)((CompoundBinaryTag)NBT_TYPE.write(this)), MinestomAdventure.NBT_CODEC);
            return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem((Keyed)this.material(), (int)this.amount(), (BinaryTagHolder)tagHolder))));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to encode itemstack nbt", e);
        }
    }

    public static sealed interface Builder
    extends TagWritable
    permits ItemStackImpl.Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder amount(int var1);

        @Contract(value="_, _ -> this")
        @NotNull
        public <T> Builder set(@NotNull DataComponent<T> var1, T var2);

        @Contract(value="_ -> this")
        @NotNull
        public Builder remove(@NotNull DataComponent<?> var1);

        @Contract(value="_, _ -> this")
        @NotNull
        default public <T> Builder set(@NotNull Tag<T> tag, @Nullable T value) {
            this.setTag(tag, value);
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public ItemStack build();
    }
}

