/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentPatch;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.CustomData;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record ItemStackImpl(Material material, int amount, DataComponentPatch components) implements ItemStack
{
    static final NetworkBuffer.Type<ItemStack> NETWORK_TYPE = new NetworkBuffer.Type<ItemStack>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, ItemStack value) {
            if (value.isAir()) {
                buffer.write(NetworkBuffer.VAR_INT, 0);
                return;
            }
            buffer.write(NetworkBuffer.VAR_INT, value.amount());
            buffer.write(NetworkBuffer.VAR_INT, value.material().id());
            buffer.write(DataComponentPatch.NETWORK_TYPE, ((ItemStackImpl)value).components);
        }

        @Override
        public ItemStack read(@NotNull NetworkBuffer buffer) {
            int amount = buffer.read(NetworkBuffer.VAR_INT);
            if (amount <= 0) {
                return ItemStack.AIR;
            }
            Material material = Material.fromId(buffer.read(NetworkBuffer.VAR_INT));
            DataComponentPatch components = buffer.read(DataComponentPatch.NETWORK_TYPE);
            return new ItemStackImpl(material, amount, components);
        }
    };
    static final NetworkBuffer.Type<ItemStack> STRICT_NETWORK_TYPE = NETWORK_TYPE.map(itemStack -> {
        Check.argCondition(itemStack.amount() == 0 || itemStack.isAir(), "ItemStack cannot be empty");
        return itemStack;
    }, itemStack -> {
        Check.argCondition(itemStack.amount() == 0 || itemStack.isAir(), "ItemStack cannot be empty");
        return itemStack;
    });
    static final BinaryTagSerializer<ItemStack> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(ItemStackImpl::fromCompound, ItemStackImpl::toCompound);

    public ItemStackImpl {
        Check.notNull(material, "Material cannot be null");
    }

    static ItemStack create(Material material, int amount, DataComponentPatch components) {
        if (amount <= 0) {
            return AIR;
        }
        return new ItemStackImpl(material, amount, components);
    }

    static ItemStack create(Material material, int amount) {
        return ItemStackImpl.create(material, amount, DataComponentPatch.EMPTY);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull DataComponent<T> component) {
        return this.components.get(this.material.prototype(), component);
    }

    @Override
    public boolean has(@NotNull DataComponent<?> component) {
        return this.components.has(this.material.prototype(), component);
    }

    @Override
    @NotNull
    public ItemStack with(@NotNull @NotNull Consumer<@NotNull ItemStack.Builder> consumer) {
        ItemStack.Builder builder = this.builder();
        consumer.accept(builder);
        return builder.build();
    }

    @Override
    @NotNull
    public ItemStack withMaterial(@NotNull Material material) {
        return new ItemStackImpl(material, this.amount, this.components);
    }

    @Override
    @NotNull
    public ItemStack withAmount(int amount) {
        if (amount <= 0) {
            return ItemStack.AIR;
        }
        return ItemStackImpl.create(this.material, amount, this.components);
    }

    @Override
    @NotNull
    public <T> ItemStack with(@NotNull DataComponent<T> component, T value) {
        return new ItemStackImpl(this.material, this.amount, this.components.with(component, value));
    }

    @Override
    @NotNull
    public ItemStack without(@NotNull DataComponent<?> component) {
        return new ItemStackImpl(this.material, this.amount, this.components.without(component));
    }

    @Override
    @NotNull
    public ItemStack consume(int amount) {
        return this.withAmount(this.amount() - amount);
    }

    @Override
    public boolean isSimilar(@NotNull ItemStack itemStack) {
        return this.material == itemStack.material() && this.components.equals(((ItemStackImpl)itemStack).components);
    }

    @Override
    @NotNull
    public CompoundBinaryTag toItemNBT() {
        return (CompoundBinaryTag)NBT_TYPE.write(this);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    private ItemStack.Builder builder() {
        return new Builder(this.material, this.amount, this.components.builder());
    }

    @NotNull
    private static ItemStack fromCompound(@NotNull CompoundBinaryTag tag) {
        String id = tag.getString("id");
        Material material = Material.fromNamespaceId(id);
        Check.notNull(material, "Unknown material: {0}", id);
        int count = tag.getInt("count", 1);
        DataComponentPatch patch = DataComponentPatch.NBT_TYPE.read((BinaryTag)tag.getCompound("components"));
        return new ItemStackImpl(material, count, patch);
    }

    @NotNull
    private static CompoundBinaryTag toCompound(@NotNull ItemStack itemStack) {
        CompoundBinaryTag.Builder tag = CompoundBinaryTag.builder();
        tag.putString("id", itemStack.material().name());
        tag.putInt("count", itemStack.amount());
        CompoundBinaryTag components = (CompoundBinaryTag)DataComponentPatch.NBT_TYPE.write(((ItemStackImpl)itemStack).components);
        if (components.size() > 0) {
            tag.put("components", (BinaryTag)components);
        }
        return tag.build();
    }

    static final class Builder
    implements ItemStack.Builder {
        final Material material;
        int amount;
        DataComponentPatch.Builder components;

        Builder(Material material, int amount, DataComponentPatch.Builder components) {
            this.material = material;
            this.amount = amount;
            this.components = components;
        }

        Builder(Material material, int amount) {
            this.material = material;
            this.amount = amount;
            this.components = new DataComponentPatch.Builder((Int2ObjectMap<Object>)new Int2ObjectArrayMap());
        }

        @Override
        public @NotNull ItemStack.Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public <T> @NotNull ItemStack.Builder set(@NotNull DataComponent<T> component, T value) {
            this.components.set(component, value);
            return this;
        }

        @Override
        public @NotNull ItemStack.Builder remove(@NotNull DataComponent<?> component) {
            this.components.remove(component);
            return this;
        }

        @Override
        public <T> void setTag(@NotNull Tag<T> tag, @Nullable T value) {
            this.components.set(ItemComponent.CUSTOM_DATA, this.components.get(ItemComponent.CUSTOM_DATA, CustomData.EMPTY).withTag(tag, value));
        }

        @Override
        @NotNull
        public ItemStack build() {
            return ItemStackImpl.create(this.material, this.amount, this.components.build());
        }
    }
}

