/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.entity.attribute.AttributeOperation;
import net.minestom.server.item.attribute.AttributeSlot;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.UniqueIdUtils;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record AttributeList(@NotNull List<Modifier> modifiers, boolean showInTooltip) {
    public static final AttributeList EMPTY = new AttributeList(List.of(), true);
    public static final NetworkBuffer.Type<AttributeList> NETWORK_TYPE = new NetworkBuffer.Type<AttributeList>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, AttributeList value) {
            buffer.writeCollection(value.modifiers);
            buffer.write(NetworkBuffer.BOOLEAN, value.showInTooltip);
        }

        @Override
        public AttributeList read(@NotNull NetworkBuffer buffer) {
            return new AttributeList(buffer.readCollection(Modifier::new, Short.MAX_VALUE), buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
    public static final BinaryTagSerializer<AttributeList> NBT_TYPE = new BinaryTagSerializer<AttributeList>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull AttributeList value) {
            ListBinaryTag.Builder modifiers = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
            for (Modifier modifier : value.modifiers) {
                modifiers.add((BinaryTag)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", modifier.attribute.name())).putString("slot", modifier.slot.name().toLowerCase(Locale.ROOT))).put("uuid", (BinaryTag)UniqueIdUtils.toNbt(modifier.modifier.id()))).putString("name", modifier.modifier.name())).putDouble("amount", modifier.modifier.amount())).putString("operation", modifier.modifier.operation().name().toLowerCase(Locale.ROOT))).build());
            }
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("modifiers", (BinaryTag)modifiers.build())).putBoolean("show_in_tooltip", value.showInTooltip)).build();
        }

        @Override
        @NotNull
        public AttributeList read(@NotNull BinaryTag tag) {
            ListBinaryTag modifiersTag;
            boolean showInTooltip = true;
            if (tag instanceof CompoundBinaryTag) {
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                modifiersTag = compound.getList("modifiers", BinaryTagTypes.COMPOUND);
                showInTooltip = compound.getBoolean("show_in_tooltip", true);
            } else if (tag instanceof ListBinaryTag) {
                ListBinaryTag list;
                modifiersTag = list = (ListBinaryTag)tag;
            } else {
                return EMPTY;
            }
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>(modifiersTag.size());
            for (BinaryTag modifierTagRaw : modifiersTag) {
                CompoundBinaryTag modifierTag;
                Attribute attribute;
                if (!(modifierTagRaw instanceof CompoundBinaryTag) || (attribute = Attribute.fromNamespaceId((modifierTag = (CompoundBinaryTag)modifierTagRaw).getString("type"))) == null) continue;
                AttributeSlot slot = AttributeSlot.valueOf(modifierTag.getString("slot").toUpperCase(Locale.ROOT));
                AttributeModifier modifier = new AttributeModifier(UniqueIdUtils.fromNbt((IntArrayBinaryTag)modifierTag.get("uuid")), modifierTag.getString("name"), modifierTag.getDouble("amount"), AttributeOperation.valueOf(modifierTag.getString("operation").toUpperCase(Locale.ROOT)));
                modifiers.add(new Modifier(attribute, modifier, slot));
            }
            return new AttributeList(modifiers, showInTooltip);
        }
    };

    public record Modifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier, @NotNull AttributeSlot slot) implements NetworkBuffer.Writer
    {
        public Modifier(@NotNull NetworkBuffer reader) {
            this(Attribute.fromId(reader.read(NetworkBuffer.VAR_INT)), new AttributeModifier(reader), reader.readEnum(AttributeSlot.class));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.attribute.id());
            this.modifier.write(writer);
            writer.writeEnum(AttributeSlot.class, this.slot);
        }
    }
}

