/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record EnchantmentList(@NotNull Map<Enchantment, Integer> enchantments, boolean showInTooltip) {
    public static final EnchantmentList EMPTY = new EnchantmentList(Map.of(), true);
    public static NetworkBuffer.Type<EnchantmentList> NETWORK_TYPE = new NetworkBuffer.Type<EnchantmentList>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, @NotNull EnchantmentList value) {
            buffer.write(NetworkBuffer.VAR_INT, value.enchantments.size());
            for (Map.Entry<Enchantment, Integer> entry : value.enchantments.entrySet()) {
                buffer.write(NetworkBuffer.VAR_INT, entry.getKey().id());
                buffer.write(NetworkBuffer.VAR_INT, entry.getValue());
            }
            buffer.write(NetworkBuffer.BOOLEAN, value.showInTooltip);
        }

        @Override
        @NotNull
        public EnchantmentList read(@NotNull NetworkBuffer buffer) {
            int size = buffer.read(NetworkBuffer.VAR_INT);
            Check.argCondition(size < 0 || size > Short.MAX_VALUE, "Invalid enchantment list size: {0}", size);
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(size);
            for (int i = 0; i < size; ++i) {
                Enchantment enchantment = Enchantment.fromId(buffer.read(NetworkBuffer.VAR_INT));
                int level = buffer.read(NetworkBuffer.VAR_INT);
                enchantments.put(enchantment, level);
            }
            boolean showInTooltip = buffer.read(NetworkBuffer.BOOLEAN);
            return new EnchantmentList(enchantments, showInTooltip);
        }
    };
    public static BinaryTagSerializer<EnchantmentList> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        CompoundBinaryTag levels = tag.keySet().contains("levels") ? tag.getCompound("levels") : tag;
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(levels.size());
        for (Map.Entry entry : levels) {
            Enchantment enchantment = Enchantment.fromNamespaceId((String)entry.getKey());
            Check.notNull(enchantment, "Unknown enchantment: {0}", entry.getKey());
            int level = BinaryTagSerializer.INT.read((BinaryTag)entry.getValue());
            if (level <= 0) continue;
            enchantments.put(enchantment, level);
        }
        boolean showInTooltip = true;
        BinaryTag patt0$temp = tag.get("show_in_tooltip");
        if (patt0$temp instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)patt0$temp;
            showInTooltip = byteTag.value() != 0;
        }
        return new EnchantmentList(enchantments, showInTooltip);
    }, value -> {
        CompoundBinaryTag.Builder levels = CompoundBinaryTag.builder();
        for (Map.Entry<Enchantment, Integer> entry : value.enchantments.entrySet()) {
            levels.put(entry.getKey().name(), BinaryTagSerializer.INT.write(entry.getValue()));
        }
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("levels", (BinaryTag)levels.build())).putBoolean("show_in_tooltip", value.showInTooltip)).build();
    });

    public EnchantmentList(@NotNull Map<Enchantment, Integer> enchantments, boolean showInTooltip) {
        enchantments = Map.copyOf(enchantments);
    }

    @NotNull
    public EnchantmentList with(@NotNull Enchantment enchantment, int level) {
        HashMap<Enchantment, Integer> newEnchantments = new HashMap<Enchantment, Integer>(this.enchantments);
        newEnchantments.put(enchantment, level);
        return new EnchantmentList(newEnchantments, this.showInTooltip);
    }

    @NotNull
    public EnchantmentList withTooltip(boolean showInTooltip) {
        return new EnchantmentList(this.enchantments, showInTooltip);
    }
}

