/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.color.Color;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.potion.CustomPotionEffect;
import net.minestom.server.potion.PotionType;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PotionContents(@Nullable PotionType potion, @Nullable RGBLike customColor, @NotNull List<CustomPotionEffect> customEffects) {
    public static final int POTION_DRINK_TIME = 32;
    public static final PotionContents EMPTY = new PotionContents(null, null, List.of());
    public static final NetworkBuffer.Type<PotionContents> NETWORK_TYPE = new NetworkBuffer.Type<PotionContents>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, PotionContents value) {
            Integer typeId = value.potion == null ? null : Integer.valueOf(value.potion.id());
            buffer.writeOptional(NetworkBuffer.VAR_INT, typeId);
            buffer.writeOptional(Color.NETWORK_TYPE, value.customColor);
            buffer.writeCollection(CustomPotionEffect.NETWORK_TYPE, value.customEffects);
        }

        @Override
        public PotionContents read(@NotNull NetworkBuffer buffer) {
            Integer typeId = buffer.readOptional(NetworkBuffer.VAR_INT);
            return new PotionContents(typeId == null ? null : PotionType.fromId(typeId), buffer.readOptional(Color.NETWORK_TYPE), buffer.readCollection(CustomPotionEffect.NETWORK_TYPE, Short.MAX_VALUE));
        }
    };
    public static final BinaryTagSerializer<PotionContents> NBT_TYPE = new BinaryTagSerializer<PotionContents>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull PotionContents value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public PotionContents read(@NotNull BinaryTag tag) {
            if (tag instanceof StringBinaryTag) {
                StringBinaryTag string = (StringBinaryTag)tag;
                return new PotionContents(PotionType.fromNamespaceId(string.value()), null, List.of());
            }
            if (!(tag instanceof CompoundBinaryTag)) {
                return EMPTY;
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)tag;
            PotionType potion = null;
            BinaryTag binaryTag = compound.get("potion");
            if (binaryTag instanceof StringBinaryTag) {
                StringBinaryTag potionTag = (StringBinaryTag)binaryTag;
                potion = PotionType.fromNamespaceId(potionTag.value());
            }
            Color customColor = null;
            BinaryTag binaryTag2 = compound.get("custom_color");
            if (binaryTag2 instanceof IntBinaryTag) {
                IntBinaryTag colorTag = (IntBinaryTag)binaryTag2;
                customColor = new Color(colorTag.value());
            }
            ArrayList<CustomPotionEffect> customEffects = new ArrayList<CustomPotionEffect>();
            ListBinaryTag customEffectsTag = compound.getList("custom_effects", BinaryTagTypes.COMPOUND);
            for (BinaryTag customEffectTag : customEffectsTag) {
                if (!(customEffectTag instanceof CompoundBinaryTag)) continue;
                CompoundBinaryTag customEffectCompound = (CompoundBinaryTag)customEffectTag;
                customEffects.add(CustomPotionEffect.NBT_TYPE.read((BinaryTag)customEffectCompound));
            }
            return new PotionContents(potion, customColor, customEffects);
        }
    };

    public PotionContents(@Nullable PotionType potion, @Nullable RGBLike customColor, @NotNull List<CustomPotionEffect> customEffects) {
        customEffects = List.copyOf(customEffects);
    }
}

